/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/* merge_user - add the av of tag/value pairs to the user record
 *
 * this routine knows that only the tag "alias" may appear more than
 * once in a user record
 */

#include "config.h"
#include "general.h"

#include "new.h"
#include "util.h"

char **merge_user(user, av)
char **user, **av;
{
    char **nuser = user, **avp;

    if (av == NULLVP)
	return user;

    for ( ; *av != NULLCP && *(av+1) != NULLCP; av += 2) {

	/* if this tag/value is already present skip to next */
	if (tagval_user(nuser, *av, *(av+1)) != NULLVP)
	    continue;

	/* if this tag is allowed multiples then add it */
	if (!strcasecmp(*av, "alias")) {
	    if ((nuser = add2av(nuser, add2cp(NULLCP, *av))) == NULLVP)
		return NULLVP;
	    if ((nuser = add2av(nuser, add2cp(NULLCP, *(av+1)))) == NULLVP)
		return NULLVP;
	    continue;
	}

	/* if this tag exists replace its value */
	if ((avp = tag_user(nuser, *av)) != NULLVP) {
	    avp++;
	    FREE(*avp);
	    *avp = add2cp(NULLCP, *(av+1));
	    continue;
	}

	/* add this new tag/value */
	if ((nuser = add2av(nuser, add2cp(NULLCP, *av))) == NULLVP)
	    return NULLVP;
	if ((nuser = add2av(nuser, add2cp(NULLCP, *(av+1)))) == NULLVP)
	    return NULLVP;
    }

    return nuser;
}
