/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"
#include "new.h"
#include "util.h"

set_db()
{
    int r = NOTOK;
    char **db, **dir, *cp, *fn = NULLCP;

    if ((db = tag_user(user_tailor, "database")) == NULLVP)
	goto cleanup;

    fn = add2cp(NULLCP, *(db+1));

    if (*fn != '/') {
	
	if ((dir = tag_user(user_tailor, "directory")) == NULLVP)
            goto cleanup;

	if (**(dir+1) != NULLC) {
	    cp = add2cp(NULLCP, *(dir+1));
	    cp = add2cp(cp, "/");
	    cp = add2cp(cp, fn);
	    FREE(fn);
	    fn = cp;
	}
    }

    if (*fn != '/') {

	if ((cp = getenv("HOME")) == NULLCP) 
	    goto cleanup;

	cp = add2cp(NULLCP, cp);
	cp = add2cp(cp, "/");
	cp = add2cp(cp, fn);
	FREE(fn);
	fn = cp;
    }

    r = set_indexfile(fn);

 cleanup:
    
    FREE(fn);
    return r;
}
