/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

static _esc_field_delim();

char *dn2str(dname)
struct bbuf *dname;
{
    struct bbuf	*rptr, *rdns= NULLBB,
		*aptr, *avas= NULLBB,
		*val= NULLBB, *tmp= NULLBB;
    OID  oid= NULLOID;
    char *ret= NULLCP, *oidstr= NULLCP, field_delim_str[2],
	  subfield_delim_str[2], *dstr= NULLCP,
	  subsubfield_delim_str[2];
    int  dint, dummy;
    long dutct;

    if (dname == NULLBB) 
        return(ret);

    if (dname->data == NULLUCP)
	return(ret);
 
    field_delim_str[0] = PEM_FIELD_DELIM;
    field_delim_str[1] = NULLC;
    subfield_delim_str[0] = PEM_SUBFIELD_DELIM;
    subfield_delim_str[1] = NULLC;
    subsubfield_delim_str[0] = PEM_SUBSUBFIELD_DELIM;
    subsubfield_delim_str[1] = NULLC;

    if (rdns_dname(dname, &rdns, READ) != OK)
	return(ret);

    for (rptr=rdns; rptr!=NULLBB; rptr=rptr->next) {
        if (avas_rdn(rptr, &avas, READ) != OK)
	    return(ret);
        ret = add2cp(ret, field_delim_str);

        for (aptr=avas; aptr!=NULLBB; aptr=aptr->next) {
	    if (aptr != avas)
        	ret = add2cp(ret, subsubfield_delim_str);
	    if (decode_ava(aptr, &oid, &val) != OK)
	        continue;

	    if (oidstr=vallookup(label_attribute,
				 strilookup(oidstr_attribute, sprintoid(oid))))
	        ret = add2cp(ret, oidstr);
	    else
		ret = add2cp(ret, sprintoid(oid));

	    /* Add the character set designator if it is T61 */
	    switch (CHARSET(val)) {
	    case DEFN_T61S:
                ret = add2cp(ret, field_delim_str);
	        ret = add2cp(ret, vallookup(label_charset,DEFN_T61S));
	    default:
	        break;
	    }

	    ret = add2cp(ret, subfield_delim_str);

            /* Decode value based on oid type */
            switch (strlookup(oidstr_syntax, sprintoid(oid))) {
	    case CaseExactString:
	    case PrintableString:
	    case CaseIgnoreString:
	    case CaseIgnoreList:
	    case NumericString:
	    case PhoneNumber:
	        switch (CHARSET(val)) {
	        case DEFN_T61S:
	            if (decode_t61s(val, &dstr, &dummy) == OK) {
		        (void) _esc_field_delim(&dstr);
		        ret = add2cp(ret, dstr);
		    }
		    break;
	        case DEFN_PRTS:
	            if (decode_prts(val, &dstr, &dummy) == OK) {
		        (void) _esc_field_delim(&dstr);
		        ret = add2cp(ret, dstr);
		    }
		    break;
	        default:
		    continue;
	        }
	        break;

	    case Boolean:
	    case Integer:
	        if (decode_int(val, &dint, &dummy) == OK)
		    ret = addint2cp(ret, dint);
	        break;

	    case UTCTime:
	        if (decode_utct(val, &dutct, &dummy) == OK)
		    ret = addlong2cp(ret, dutct);
	        break;

	    case OctetString:
	        if (decode_octs(val, &tmp, &dummy) == OK)
	            ret = addhex2cp(ret, tmp->data, tmp->length);
	    default:
	        ret = addhex2cp(ret, val->data, val->length);
	        break;
            }
        }
    }
    ret = add2cp(ret, field_delim_str);

    FREE_BBUFS(avas);
    FREE_BBUFS(rdns);
    FREE_BBUF(tmp);
    FREE_BBUF(val);
    FREE_OID(oid);
    FREE(dstr);

    return(ret);
}

/* escape PEM_FIELD_DELIM within value field */

static _esc_field_delim(str)
char **str;
{
    char *tcp, *ptr= *str;
    int offset, tlen;

    for (tcp=INDEX(ptr,PEM_FIELD_DELIM); tcp!=NULLCP;
	 tcp = INDEX(tcp+2*sizeof(char),PEM_FIELD_DELIM)) {
	if (*(tcp+sizeof(char))!=PEM_FIELD_DELIM) {
	    /* escape this delimiter */ 
	    offset = tcp - ptr;
	    tlen = strlen(ptr)+1 - (tcp-ptr);
    	    if ((ptr = realloc(ptr,(unsigned)((strlen(ptr)+2)*sizeof(char))))
		== NULLCP) 
		return(NOTOK);
	    BCOPY(ptr+offset, ptr+offset+sizeof(char), tlen);
        }
    }
    *str = ptr;
    return(OK);
}
