/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "allocate.h"
#include "bbuf.h"
#include "msg.h"
#include "user_list.h"
#include "util.h"

struct bbuf *hdr2bbuf(hdr)
char *hdr;
{
    struct bbuf *tmp= NULLBB, *ret= NULLBB;

    if (hdr == NULLCP)
	return(ret);

    if ((tmp=alloc_bbuf()) == NULLBB)
	return(ret);

    tmp->length = strlen(hdr);
    tmp->data = (unsigned char *)hdr;

    bdecode(tmp, &ret);

    tmp->data = NULLUCP;
    FREE_BBUF(tmp);

    return(ret);
}

struct msg *alloc_msg()
{
    struct msg *ret= NULL_MSG;

    allocate(&ret, struct msg, sizeof(struct msg));

    ret->services = ret->comment = ret->unkheader = NULLVP;
    ret->dekalg = ret->sigalg = NULLCP;
    ret->dekinfo = ret->signature = ret->recipkey = ret->keyalg
	= ret->origkey = NULLBB;
    ret->origusers = ret->recipusers = NULLUL;
    ret->next = NULL_MSG;

    return(ret);
}


free_msgs(msgs)
struct msg *msgs;
{
    struct msg *msg = NULL_MSG, *next = NULL_MSG;

    for (msg = msgs; msg != NULL_MSG; msg = next) {
	next = msg -> next;
	FREE_MSG(msg);
    }

    return(OK);
}


free_msg(msg)
struct msg *msg;
{
    if (msg == NULL_MSG)
	return(OK);

    FREE_AV(msg->services);
    FREE_AV(msg->comment);
    FREE_AV(msg->unkheader);
    FREE(msg->sigalg);
    FREE(msg->dekalg);

    FREE_BBUFS(msg->dekinfo);
    FREE_BBUFS(msg->signature);
    FREE_BBUFS(msg->recipkey);
    FREE_BBUFS(msg->keyalg);
    FREE_BBUFS(msg->origkey);

    FREE_ULS(msg->origusers);
    FREE_ULS(msg->recipusers);

    free((char *)msg);
    return(OK);
}


display_msg(msg)
struct msg *msg;
{
    int i; 
    char  **av = NULLVP;
    struct bbuf *bb1, *bb2;
    struct user_list *ulptr = NULLUL;

    if (msg == NULL_MSG)
	return(OK);


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "SERVICES"),
			   (msg->services) ? NULLCP : " - NULL"));
    if (msg->services) 
	for (i = 0; msg->services[i]; i++)
	    av = add2av(av, add2cp(NULLCP, msg->services[i]));


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "COMMENT"),
			   (msg->comment) ? NULLCP : " - NULL"));
    if (msg->comment)
	for (i = 0; msg->comment[i]; i++)
	    av = add2av(av, add2cp(NULLCP, msg->comment[i]));


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "UNKNOWN HEADERS"),
			       (msg->unkheader) ? NULLCP : " - NULL"));
    if (msg->unkheader) {
	for (i = 0; msg->unkheader[i]; i++)
	    av = add2av(av, add2cp(NULLCP, msg->unkheader[i]));
    }


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "SIGNATURE ALGORITHM - "),
			   (msg->sigalg) ? msg->sigalg : "NULL"));



    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "DEK ALGORITHM - "),
			   (msg->dekalg) ? msg->dekalg : "NULL"));

    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "DEK PARAMETER(S)"),
			   (msg->dekinfo) ? NULLCP : " - NULL"));
    if (msg->dekinfo)
	disp_bbuf(msg->dekinfo, &av);


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "RECIPIENT USER(S)"),
			   (msg->recipusers) ? NULLCP : " - NULL"));
    for (ulptr = msg->recipusers; ulptr != NULLUL; ulptr = ulptr->next) {
        (void) disp_user(ulptr->user, &av);
	av = add2av(av, add2cp(NULLCP, ""));
    }

    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "RECIPIENT KEY(S)"),
			   (msg->recipkey) ? NULLCP : " - NULL"));
    if (msg->recipkey)
	for (bb1 = msg->recipkey, bb2 = msg->keyalg;
	     bb1 && bb2;
	     bb1 = bb1->next, bb2 = bb2->next) {
	    av = add2av(av, add2cp(NULLCP, (char *)bb2->data));
	    disp_bbuf(bb1, &av);
	    av = add2av(av, add2cp(NULLCP, ""));
	}


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "ORIGINATOR USER(S)"),
			   (msg->origusers) ? NULLCP : " - NULL"));
    for (ulptr = msg->origusers; ulptr != NULLUL; ulptr = ulptr->next) {
        (void) disp_user(ulptr->user, &av);
        av = add2av(av, add2cp(NULLCP, ""));
    }

    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "ORIGINATOR KEY(S)"),
			   (msg->origkey) ? NULLCP : " - NULL"));
    if (msg->origkey)
	for (bb1 = msg->origkey; bb1; bb1 = bb1->next) {
	    disp_bbuf(bb1, &av);
	    av = add2av(av, add2cp(NULLCP, ""));
	}


    av = add2av(av, add2cp(NULLCP, ""));
    av = add2av(av, add2cp(add2cp(NULLCP, "-SIGNATURE(S)"),
			       (msg->signature) ? NULLCP : " - NULL"));
    if (msg->signature)
	for (bb1 = msg->signature; bb1; bb1 = bb1->next) {
	    disp_bbuf(bb1, &av);
	    av = add2av(av, add2cp(NULLCP, ""));
	}


    for (i = 0; av[i]; i++)
	printf("%s\n", av[i]);
    FREE_AV(av);

    return(OK);
}
