/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "key.h"
#include "msg.h"
#include "new.h"

int pem_verify(msg, iocbs)
struct msg *msg;
struct cbstruct *iocbs;
{
    struct bbuf *mic = NULLBB,
		*emic = NULLBB,
		*key = NULLBB,
                ekey;
    struct algent *mic_ae = NULL_ALGENT;
    struct algent *msg_ae = NULL_ALGENT;
    struct algid  *mic_aid = NULL_ALGID;
    char *pubkey = NULLCP;
    int ret = NOTOK;

    if (msg == NULL_MSG || msg -> origusers == NULLUL || iocbs == NULL_IOCBS
	|| iocbs -> in_data == NULL_INCB) {
	(void) cp2cb(iocbs -> out_errs, "pem_verify: missing arguments");
	goto cleanup;
    }

    /* get the hash/mic algorithm */
    if ((msg_ae = getalghdrstr(algorithms, msg -> sigalg, MIC))
	== NULL_ALGENT) {
	char buffer[1024];

	(void) sprintf(buffer, "%s: unsupported signature algorithm",
		       msg -> sigalg);
	(void) cp2cb(iocbs -> out_errs, buffer);
	goto cleanup;
    }

    /* generate new MIC from plaintext */
    /* cbgen_mic(msg_ae -> code, NULL_FUNC, iocbs->in_data, &mic); */
    (void) cbgen_md5(NULL_KEY, iocbs->in_data, &mic);

    /* encode new MIC and MIC algid */
    if ((mic_ae = getalgcode(algorithms, msg_ae -> code, MIC))
	== NULL_ALGENT) {
	(void) cp2cb(iocbs -> out_errs, "internal error(1)");
	goto cleanup;
    }
    mic_aid = alloc_algid();
    mic_aid->alg = mic_ae->code;
    if (encode_mic(mic, mic_aid, &emic) != OK) {
	(void) cp2cb(iocbs -> out_errs, "Unable to encode new MIC");
	goto cleanup;
    }

    /* get originator public key and setup for use */

    if ((pubkey = key_user(msg -> origusers -> user)) == NULLCP) {
	(void) cp2cb(iocbs -> out_errs,
		     "Unable to extract originator's public key");
	goto cleanup;
    }

    ekey.data = (unsigned char *)pubkey;
    ekey.length = strlen (pubkey);
    bdecode (&ekey, &key);

    if (set_key(key) != OK) {
	(void) cp2cb(iocbs -> out_errs,
		     "Unable to use originator's public key");
	goto cleanup;
    }

    /* verify signature */
    if (verify(msg -> signature, emic) != OK) {
	(void) cp2cb(iocbs -> out_errs, "Signature does not verify!");
	goto cleanup;
    }

    ret = OK;

 cleanup:

    FREE_ALGID(mic_aid);
    FREE_BBUF(emic);
    FREE_BBUF(key);
    FREE_BBUF(mic);

    return(ret);
}
