/*
**	ssh_cmsg.h	-- header file for coding client messages
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**	See the LICENSE file.
*/

#ifndef __SSH_CMSG_H
#define __SSH_CMSG_H

#include "ssh_msg.h"

#include "ssh_mp_int.h"
#include "ssh_mp_stream.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
**	encode the SSH_CMSG_SESSION_KEY message
*/
int ssh_cmsg_session_key_encode(uint8_t * data, uint32_t * data_len,
	uint8_t cipher_type,
	uint8_t * cookie,
	MP_Int session_key,
	uint32_t protocol_flags);

/*
**	encode the SSH_CMSG_USER message
*/
int ssh_cmsg_user_encode(uint8_t * data, uint32_t * data_len,
	uint8_t * user);

/*
**	encode the SSH_CMSG_AUTH_PASSWORD message
*/
int ssh_cmsg_auth_password_encode(uint8_t * data, uint32_t * data_len,
	uint8_t * passwd);

/*
**	encode the SSH_CMSG_REQUEST_PTY message
*/
int ssh_cmsg_request_pty_encode(uint8_t * data, uint32_t * data_len,
	char * terminal_type, uint32_t height, uint32_t width,
	uint32_t x_pixels, uint32_t y_pixels, uint8_t * tty_mode,
	int tty_mode_len);

/*
**	encode the SSH_CMSG_EXEC_SHELL
*/
int ssh_cmsg_exec_shell_encode(uint8_t * data, uint32_t * data_len);

/*
**	encode the SSH_CMSG_STDIN_DATA
*/
int ssh_cmsg_stdin_data_encode(uint8_t * data, uint32_t * data_len,
	uint8_t * str, int len, int data_size);

/*
**	encode SSH_CMSG_EXIT_CONFIRMATION
*/
int ssh_cmsg_exit_confirmation_encode(uint8_t * data, uint32_t * data_len);

/*
**	encode SSH_CMSG_AUTH_RSA
*/
int ssh_cmsg_auth_rsa_encode(uint8_t * data, uint32_t * data_len,
	MP_Int public_key_modulus);

/*
**	encode SSH_CMSG_AUTH_RSA_RESPONSE
*/
int ssh_cmsg_auth_rsa_response_encode(uint8_t * data, uint32_t * data_len,
	uint8_t * md5_digest);

/*
**	encode SSH_CMSG_WINDOW_SIZE
*/
int ssh_cmsg_window_size_encode(uint8_t * data, uint32_t * data_len,
	uint32_t height, uint32_t width, uint32_t x_pixels, uint32_t y_pixels);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_CMSG_H */

