#ifndef __UI_H__
#define __UI_H__

#include "display.h"
#include "erf.h"

void *ui_init(long (*down_write)(unsigned char *,long,void *,Erf,void*),
		void *down_state, Erf,void*);
long ui_write(unsigned char *data, long len, void *state, Erf,void*);
void ui_dispatch(unsigned char *data, long len, void *state, Erf,void*);

void ui_setconnid(char *connid,void *state, Erf,void*);

void ui_set_setterm(
	void (*down_setterm)(char *,int,int,int,int,void*,Erf,void*),
	void *state, Erf,void*);

void ui_setdpy(Display *dpy, void *state);

/* Grumble; we can't pass data to arrive with the event handler callback.
   We'll make these global for now. */
extern void *saveuistate;
extern Erf saveerf;
extern void *saveerfp;

#define ui_fatal(reason) erf(1, "ui", reason, __FILE__, __LINE__, erfp)

#endif
