/* Handler for the standard Edit menu */

#include <Pilot.h>
#include "TGsshRsc.h"
#include "editmenu.h"

static FieldPtr GetFocusObjectPtr(FormPtr frm)
{
    Word focus = FrmGetFocus(frm);
    if (focus == noFocus) return NULL;

    return FrmGetObjectPtr(frm, focus);
}

Boolean EditMenuHandleEvent(Word menuitem, FormPtr frm)
{
    Boolean handled = false;
    FieldPtr fld;

    switch(menuitem) {
    case EditMenuUndo:
        fld = GetFocusObjectPtr(frm);
        if (fld) {
            FldUndo(fld);
        }
        handled = true;
        break;

    case EditMenuCut:
        fld = GetFocusObjectPtr(frm);
        if (fld) {
            FldCut(fld);
        }
        handled = true;
        break;

    case EditMenuCopy:
        fld = GetFocusObjectPtr(frm);
        if (fld) {
            FldCopy(fld);
        }
        handled = true;
        break;

    case EditMenuPaste:
        fld = GetFocusObjectPtr(frm);
        if (fld) {
            FldPaste(fld);
        }
        handled = true;
        break;

    case EditMenuSelectAll:
        fld = GetFocusObjectPtr(frm);
        if (fld) {
            FldSetSelection(fld, 0, FldGetTextLength(fld));
        }
        handled = true;
        break;

    case EditMenuKeyboard:
        SysKeyboardDialog(kbdDefault);
        handled = true;
        break;

    case EditMenuGraffiti:
        SysGraffitiReferenceDialog(referenceDefault);
        handled = true;
        break;
    }

    return handled;
}
