#include <sys/types.h>
#include <sys/statvfs.h>
#include <stdio.h>

int main(int argc, char **argv)
{
  int err = 0;
  struct statvfs buf;

  /* validate input */
  if (argc != 2) {
    fprintf(stderr, "Usage: %s [mount_point]\n",
	    argv[0]);
    exit(1);
  }

  err = statvfs(argv[1], &buf);
  if (err < 0) {
    perror(argv[0]);
  }
  exit(err);
}
