#include "ecashlib.h"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "t_tcp.h"
#include "t_print.h"

#include "onl_tcp.h"


#include "t_config.h"



EC_Address *mint_addr_ptr = NULL;
EC_Pocket *global_pocket_lnk = NULL;



void handle_action(EC_ActionHandler *acth_lnk);


void handle_action(EC_ActionHandler *acth_lnk)
{
  struct tcp_conn **conn_array = NULL;

  struct tcp_conn *conn_local_ptr = NULL;

  unsigned short int conn_index = 0;
  unsigned short int conn_num = 0;

  EC_Errno acth_err_state = EC_ERR_INVALID;
  EC_Msg *message_ptr = NULL;
  EC_Address *addr_ptr = NULL;
  char *hostname = NULL;
  char *hostname_temp = NULL;
  int portnum = 0;


  int stop_now = 0;

  while (!stop_now) {
    acth_err_state = EC_acth_get_errno(acth_lnk);
    if (acth_err_state != EC_ERR_NONE) {
		if ((acth_err_state == EC_ERR_ACTION_ABORTED_REWOUND) ||
			(acth_err_state == EC_ERR_ACTION_ABORTED_FF)) {
		/* Um.  Okay.  So it has been aborted. */
			stop_now = 1;
		} else{

		/* Uh-oh. an error.  Let's abort. */
		  EC_acth_abort_action(acth_lnk);
		}
    }

    
    if ((EC_acth_get_state(acth_lnk) == EC_STATE_NEED_SEND_MSG) ||
	(EC_acth_get_state(acth_lnk) == EC_STATE_NEED_RECEIVE_MSG)) {


      addr_ptr = EC_acth_get_address(acth_lnk);

      /* convert the EC_Address into a NULL-terminated
	 hostname string and an unsigned int port num */
      hostname = test_tcp_addr_to_hostname(addr_ptr);
      portnum = test_tcp_addr_to_portnum(addr_ptr);

      /* Do we already have a connection to this interlocutor? */
      for (conn_index = 0;
	   conn_index < conn_num
	     && strcmp(conn_array[conn_index]->host, hostname)
	     && (conn_array[conn_index]->port == portnum);
	   conn_index++);

      if (conn_index >= conn_num) {
	/* If not, open one. */

	/*!Note: tcp_open_conn calls "free()" on its first argument... */
	hostname_temp = (char *) malloc (strlen(hostname) + 1);
	strcpy(hostname_temp, hostname);

	conn_local_ptr = tcp_open_conn(hostname_temp, portnum, 0);

	if (conn_local_ptr != NULL) {
	  conn_num = conn_index + 1;

	  conn_array = realloc(conn_array, sizeof(struct tcp_conn *) * 
			       conn_num);
	
	  conn_array[conn_index] = conn_local_ptr;
	} else {
	  /* whoops.  tcp_open_conn() failed.  Probably network is down,
	      wrong address, or something like that. */
	  /* We could put some really complex code here if we wanted.  Try 
	     again?  Wait and try again?  Alert user?  Try alternate address, 
	     alternate network, etc?  Or just do the simple thing: */
	  EC_acth_abort_action(acth_lnk);
	}
      } /* if (conn_index >= conn_num) */

      EC_addr_free(addr_ptr);
      addr_ptr = NULL;
      free(hostname);
      hostname = NULL;
    } /* if the state of the acth is need-to-send or need-to-receive */


    switch (EC_acth_get_state(acth_lnk)) {
      case EC_STATE_NEED_SEND_MSG:
        message_ptr = EC_acth_get_msg(acth_lnk);
	
        if (conn_array[conn_index] != NULL) {
	  if (test_tcp_send_msg(message_ptr, conn_array[conn_index]) == 0) {
		  /* cool it worked.  Be happy. */
	  } else {
		EC_acth_abort_action(acth_lnk);
	  }
	}

	if (message_ptr != NULL) {
		EC_msg_free(message_ptr);
	}
	message_ptr = NULL;
	break;

      case EC_STATE_NEED_RECEIVE_MSG:
        if (conn_array[conn_index] != NULL) {
	  if (test_tcp_recv_msg(&message_ptr, conn_array[conn_index]) == 0) {
	    EC_acth_process_msg(acth_lnk, message_ptr, addr_ptr);
	  } else {
	    EC_acth_abort_action(acth_lnk);
	  }
	}

	if (message_ptr != NULL) {
		EC_msg_free(message_ptr);
	}
	message_ptr = NULL;
	break;

      case EC_STATE_DONE:
      default:
	stop_now = 1;
	break;
    } /* switch(EC_acth_get_state(acth_lnk)) */
  } /* while(!stop_now) */

  /* Clean up all connections that were created for this conversation. */
  for (conn_index = 0; conn_index < conn_num; conn_index++) {
    tcp_close_conn(conn_array[conn_index]);
  }

  free(conn_array);

} /* handle_network_conversation */
	

int open_bank_account(EC_Pocket *pocket_ptr);


/* ret val 0 = success, non-zero = failure */
int open_bank_account(EC_Pocket *pocket_ptr)
{
	EC_ActionHandler *acth_ptr = NULL;
	int ret_val = -1;

	acth_ptr = EC_pocket_begin_open_account(pocket_ptr, 
		MY_ACC_PASSWORD);

	handle_action(acth_ptr);

	if (EC_acth_get_errno(acth_ptr) == EC_ERR_NONE) {
		ret_val = 0;
	} else {
		ret_val = -1;
	}

	EC_acth_free(acth_ptr);

	return ret_val;
} /* void open_bank_account() */


void withdraw_two_bogusbuck_cents(EC_Pocket *pocket_ptr);


void withdraw_two_bogusbuck_cents(EC_Pocket *pocket_ptr)
{
	EC_ActionHandler *acth_ptr = NULL;

	acth_ptr = EC_pocket_begin_withdrawal(pocket_ptr,
		2, 1);

	handle_action(acth_ptr);

	EC_acth_free(acth_ptr);

	return;
} /* withdraw_two_bogusbuck_cents */


void pay_one_bogusbuck_cent(EC_Pocket *pocket_ptr,
	const EC_AccountID *recip_accID_lnk,
	const EC_Address *recip_addr_lnk);


void pay_one_bogusbuck_cent(EC_Pocket *pocket_ptr,
	const EC_AccountID *recip_accID_lnk,
	const EC_Address *recip_addr_lnk)			       
{
	EC_ActionHandler *acth_ptr = NULL;

	acth_ptr = EC_pocket_begin_make_payment(pocket_ptr,
		EC_PROTOCOL_ECASH_ONLINE_COINS,
		1, "Here is your one bogusbuck cent.  Enjoy.",
		recip_accID_lnk, recip_addr_lnk);


	handle_action(acth_ptr);

	EC_acth_free(acth_ptr);

	return;
}


void accept_payment(EC_Pocket *pocket_lnk, EC_Msg *payment_msg_lnk);


void accept_payment(EC_Pocket *pocket_lnk, EC_Msg *payment_msg_lnk)
{
	EC_ActionHandler *acth_ptr = NULL;

	acth_ptr = EC_pocket_begin_accept_payment(pocket_lnk, payment_msg_lnk);

	handle_action(acth_ptr);

	EC_acth_free(acth_ptr);

	return;
} /* accept_any_payment */


void ignore_payment_request(void);


void ignore_payment_request(void)
{
  test_log(EC_LOGLEVEL_INFO, "Hahahahaha!  Sucker!\n");

  return;
} /* ignore_payment_request */


int handle_connection_callback(struct tcp_conn *conn, char *host);


int handle_connection_callback(struct tcp_conn *conn, char *host)
{
  EC_Msg *new_msg_ptr = NULL;

  if (test_tcp_recv_msg(&new_msg_ptr, conn)) {
    return -1; /* whoops.  Error! */
  }

  if (EC_msg_get_type(new_msg_ptr) == EC_MSGTYPE_PAYMENT) {
    /* A payment?  We'll take it! */
    accept_payment(global_pocket_lnk, new_msg_ptr);
  } else if (EC_msg_get_type(new_msg_ptr) == EC_MSGTYPE_PAYREQ) {
    /* Ha!  What kind of a fool do you take me for? */
    ignore_payment_request();
  } else {
    test_log(EC_LOGLEVEL_WARNING, "Unrecognized message received.\n");
  }

  EC_msg_free(new_msg_ptr);

  return 0;
} /* handle_connection_callback */


int main(int argc, char **argv)
{
	/* variables */
	EC_Pocket *pocket_ptr = NULL;
	EC_PocketID *pocketID_ptr = NULL;
	EC_AccountID *my_accID_ptr = NULL;
	EC_AccountID *other_accID_ptr = NULL;
	EC_Address *other_addr_ptr = NULL;
	EC_Info *info_ptr = NULL;
	int retval = -1;
	int portnum = -1;
	int status = -1;
	int socket_descriptor = -1;
	int looper = 0;


	/* call EC_main_init */
	EC_main_init(malloc, realloc, free, test_yield, test_log);

	/* Hello, world! */
	printf("Worldling Yodel!\n\n");

	/* boot up your networking stuff: */
	retval = tcp_init();


	/* Now the first thing to do is instantiate an EC_Pocket.
	   As you know EC_pocket_new() takes an EC_PocketID, and
	   the mint's EC_Address, and a few strings as arguments, 
	   so we must first instantiate and EC_PocketID and an 
	   EC_Address. */

	mint_addr_ptr = test_hostname_to_addr(TEST_MINT_HOSTNAME,
		TEST_MINT_PORTNUM);
	my_accID_ptr = EC_accID_new(BOGUS_BUCK_MINT_ID, MY_ACC_NAME);
	pocketID_ptr = EC_pocketID_new(my_accID_ptr, MY_POCKET_DIR);



	pocket_ptr = EC_pocket_new(pocketID_ptr, mint_addr_ptr,
		"Hello this is Bryce testing the new ecashlib.",
		MY_POCKET_PASSWORD, 
	        MY_RANDOM_STRING,
		MY_ACC_PASSWORD);


	if (pocket_ptr != NULL) {
		/* Okay we have created a pocket!  How exciting! */



		info_ptr = EC_pocket_get_info(pocket_ptr);
		test_print_info(info_ptr);


		/* Open up a bank account for this pocket if it has not already
		   been opened. */
		if (EC_info_get_acct_status(info_ptr) == EC_ACCOUNTSTATUS_UNOPENED) {
			if (open_bank_account(pocket_ptr) != 0) {
				/* crash and burn!  Bye. */
				status = -1;
			} else {
				status = 0;
			}
		}


		if (status == 0) {
			/* Withdraw two bogusbuck cents. */
			withdraw_two_bogusbuck_cents(pocket_ptr);
		

			/* Pay one bogusbuck cent to my other account. */
			other_accID_ptr = EC_accID_new(BOGUS_BUCK_MINT_ID, 
				MY_OTHER_ACC_NAME);
			other_addr_ptr = test_hostname_to_addr(MY_OTHER_ACC_HOSTNAME,
				MY_OTHER_ACC_PORTNUM);

			pay_one_bogusbuck_cent(pocket_ptr, other_accID_ptr, 
				other_addr_ptr);
		
			for (looper = 0; looper < 10000; looper++) {
				/* Aw heck.  Let's give away the farm!  Here!  Have all my
				money! */
				pay_one_bogusbuck_cent(pocket_ptr, other_accID_ptr, 
					other_addr_ptr);
			}
		}



		/* start listening on a port for incoming messages from other
		   Ecash applications */
		   /* compile the following chunk if you want this test program to
			  listen on a port in order to accept payments.  Unfortunately
			  EC_pocket_begin_accept_payment() isn't implemented yet, but
			  this is how it would work... */
		   #if 0
		if (status == 0) {
			/* global_pocket_lnk is to give our callback method access to 
			our pocket pointer */
			global_pocket_lnk = pocket_ptr;
		
			portnum = TCP_LISTEN_PORT;
			socket_descriptor = tcp_bindsock(&portnum, 0);
			if (socket_descriptor != -1) {
				tcp_listen(&handle_connection_callback, -1, NULL);
			}

		}
		   #endif
	}



	/* clean up */
	if (info_ptr != NULL) {
		EC_info_free(info_ptr);
		info_ptr = NULL;
	}

	if (pocket_ptr != NULL) {
		EC_pocket_free(pocket_ptr);
	}

	if (mint_addr_ptr != NULL) {
		EC_addr_free(mint_addr_ptr);
	}

	if (pocketID_ptr != NULL) {
		EC_pocketID_free(pocketID_ptr);
	}

	if (my_accID_ptr) {
		EC_accID_free(my_accID_ptr);
	}

	tcp_exit();
	EC_main_cleanup();
	test_log(EC_LOGLEVEL_DEBUG, "Close the log file now.");

	return 1; /* Success!  Yahoo! */
} /* int main(int argc, char **argv) */


