class cipherdata {
  protected:
  char cipher[CLENGTH];
  char type;
  int length;
  int period;
  int period_set;

  int base_exec_option(char option);
  void write_cipher(void);
  virtual int get_cipher_from_file(FILE *fptr);
  virtual int period_valid(void);
  virtual int set_period(int newperiod=0);
  virtual void setup_key(void);
  virtual void copy_key(char *string){};
  virtual void decipher(char *string){};
  virtual void get_cipher(char *string);
  virtual void init_cipher(void){};
  virtual void read_key(FILE *fptr){};

  public:
  char read_header(FILE *fptr);
  int read_cipher(FILE *fptr);
  void set_type(char ctype){ type = ctype; };
  virtual int execute_option(char option){ return 0;};
  virtual void show_cipher(void){};
  virtual void show_key(void){};
  virtual void show_menu(void){};
};

class transposition:public cipherdata {
  protected:
  int clen;
  char *ocipher;

  void undo(void);
  void horiz2vert(void);
  void interchange_columns(int column1, int column2);
  void interchange_rows(int row1, int row2);
  void rotate_column(int column, int amount);
  void vert2horiz(void);
};
  


class baconian:public cipherdata {
  char key[26];
  int period;
  char *balphabet[27];

  int set_period(int);
  void bconv(char letter, char btext[6]);
  void bdeconv(char btext[6]);
  void bstringtochar(char *string);
  void clear_key(void);
  void copy_key(char *string);
  void decipher(char *string);
  void groupsub(void);
  void init_cipher(void){};
  void read_key(FILE *fptr);
  void stringtob(char *string);
  void sub_key(char letter1, char letter2);
  void sub_string(char letter1, char *string);
  void substitute(void);
  void undo(void);
  void undo_letter(char letter);

  public:
  baconian(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class homophonic:public cipherdata {
  int key[5];
  int ocipher[CLENGTH];
  int hist[4][25];

  char get_pt(int number);
  int fit_hist(int newhist[25]);
  int get_cipher_from_file(FILE *fptr);
  int set_period(int newperiod);
  void alphfit(void);
  void copy_key(char *string);
  void decipher(char *string);
  void decode(char *message);
  void init_cipher(void);
  void read_key(FILE *fptr);
  void shift_row(int row, int amount);
  void sub_letter(int number, char lettr);
  void substitute(void);
  void undo(void);

  public:
  homophonic(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class vigenere:public cipherdata {
  protected:
  char *key;
  int clen;

  virtual char get_ct(char pt, char key_letter);
  virtual char get_key_letter(char ct, char pt);
  virtual char get_pt(char ct, char key_letter);
  void alphfit(void);
  void copy_key(char *string);
  void decipher(char *string);
  void decode(char *meswsage);
  void fit_column(int column);
  void init_cipher(void);
  void read_key(FILE *fptr);
  void setup_key(void);
  void sub_letter(char ct_letter, char pt_letter, int column);
  void substitute(void);
  void undo(void);

  public:
  vigenere(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class beaufort:public vigenere{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class variant:public vigenere{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class porta:public vigenere{
  char get_ct(char pt, char key_letter);
  char get_key_letter(char ct, char pt);
  char get_pt(char ct, char key_letter);
};

class aristocrat:public cipherdata{
  char ocipher[MAXLINES][CLENGTH];
  char key[26];
  int num_lines;

  int get_cipher_from_file(FILE *fptr);
  int set_period(int newperiod);
  void alter_key(char ct_letter, char pt_letter);
  void copy_key(char *string);
  void decipher(char *string);
  void init_cipher(void){};
  void read_key(FILE *fptr);
  void substitute(void);
  void undo(void);

  public:
  aristocrat(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class quag2:public cipherdata {
  char **okey;
  char **key;
  int clen;

  int alter_key(int keynum, char ct_letter, char pt_letter);
  void clear_key(int keynum);
  void copy_key(char *string);
  void decipher(char *string);
  void decode(char *message);
  void init_cipher(void);
  void read_key(FILE *fptr);
  void setup_key(void);
  void substitute(void);
  void undo(void);
  void undo_letter(int keynum, char letter);

  public:
  quag2(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class nihilist:public transposition {
  int *key;

  int set_period(int newperiod);
  void copy_key(char *string);
  void decipher(char *string);
  void get_cipher(char *string);
  void init_cipher(void);
  void move_stuff(void);
  void read_key(FILE *fptr);

  public:
  nihilist(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class cadenus:public transposition {
  int *key;

  int set_period(int period);
  void copy_key(char *string);
  void decipher(char *string);
  void init_cipher(void);
  void move_stuff(void);
  void read_key(FILE *fptr);
  void rotate(void);

  public:
  cadenus(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class phillips:public cipherdata {
  char key[5][5];
  int philsquares[8][5];

  int set_period(void);
  void clear_key(void);
  void copy_key(char *string);
  void decipher(char *string);
  void decrypt(char *string, int square);
  void init_cipher(void);
  void read_key(FILE *fptr);
  void substitute(void);
  void undo(void);
  void undo_letter(char letter);

  public:
  phillips(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class swagman:public cipherdata {
  int **key;
  int num_squares;

  int period_valid(void);
  void clear_key(void);
  void copy_key(char *string);
  void decipher(char *string);
  void init_cipher(void);
  void move_stuff(void);
  void read_key(FILE *fptr);
  void setup_key(void);
  void substitute(void);
  void undo(void);
  void update_key(int number, int row, int column);

  public:
  swagman(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_key(void);
  void show_menu(void);
};

class railfence:public cipherdata {
  protected:
  int maxraillen;
  int keylen;
  int *clen;
  char **block;
  int *key;
  int *okey;

  int *find_columns(int index);
  int period_valid(void);
  void change_rails(void);
  void copy_key(char *string);
  void decipher(char *string);
  void fill_block(void);
  void init_cipher(void);
  void move_startpos(void);
  void read_key(FILE *fptr);
  void setup_key(void);
  void set_key(int startpos);
  virtual void move_stuff(void);

  public:
  railfence(void);
  int execute_option(char option);
  void show_menu(void);
  void show_cipher(void);
  void show_key(void);
};

class redefence:public railfence {
  void move_stuff(void);
  void interchange_rails(void);
};

class columnar:public cipherdata {
  int maxcollen;
  int *clen;
  char **block;
  int *key;

  int *find_columns(int index);
  int execute_option(char option);
  void change_period(void);
  void copy_key(char *string);
  void decipher(char *string);
  void fill_block(void);
  void init_cipher(void);
  void init_key(void);
  void move_stuff(void);
  void read_key(FILE *fptr);
  void setup_key(void);
  void undo(void);

  public:
  columnar(void);
  void show_menu(void);
  void show_cipher(void);
  void show_key(void);
};

class morse:public cipherdata {
  protected:
  int keylen;
  char key[26];

  virtual int period_valid();
  virtual char *get_morse(char index){};
  virtual void do_sub(char number, int pattern);
  virtual void undo(){};
  int empty_string(char *string);
  int get_cipher_from_file(FILE *fptr);
  int morse2num(char *string);
  int valid_pattern(char *pattern);
  void copy_key(char *string);
  void decipher(char *string);
  void decrypt(char *string);
  void read_key(FILE *fptr);
  void setup_key(void);
  virtual void substitute(void);
  char *num2morse(int num);
  char morse2roman(char *morsestring);

  public:
  morse(void);
  int execute_option(char option);
  void show_cipher(void);
  void show_menu(void);
};

class pollux:public morse{
  char *get_morse(char index);
  int set_period(int newperiod=0);
  void substitute(void);
  void undo(void);

  public:
  void show_key(void);
};

class morbit:public morse{
  char *get_morse(char index);
  int set_period(int newperiod=0);
  void undo(void);

  public:
  void show_key(void);
};

class fmorse:public morse{
  char *get_morse(char index);
  int get_cipher_from_file(FILE *fptr);
  int set_period(int newperiod=0);
  void do_sub(char letter, int pattern);
  void undo(void);

  public:
  void show_key(void);
};
