/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

nihilist::nihilist(){
  *cipher = '\0';
  ocipher = NULL;
  key = NULL;
  clen = 0;
  length = 0;
  period = 0;
  period_set = FALSE;
}

int nihilist::execute_option(char option){
  switch(option){
    case MOVE:
      move_stuff();
      break;
    case UNDO:
      undo();
      vert2horiz();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

int nihilist::set_period(int newperiod){
  int i;

  if(period_set == FALSE || newperiod){
    period = newperiod;
    if(!period){
      for(i = 0; i*i <= length; i++){
	if(i*i == length){
	  period = i;
	  period_set = TRUE;
	}
      }
      if(period*period != length){
	msgerror("Nihilist ciphers must have a square number of letters.");
	period = 0;
	period_set = FALSE;
      }
    }
    else
      period_set = TRUE;

    delete key;
    key = new int[period];
    for(i = 0; i < period; i++)
      key[i] = i+1;
  }

  return TRUE;
}

void nihilist::init_cipher(){
  if(ocipher == NULL){

    clen = period;
    length = strlen(cipher);
  
    ocipher = strdup(cipher);
  
    vert2horiz();
  }
}

void nihilist::show_menu(){
  menu(1, "(M)ove columns/rows  (U)ndo changes  (W)rite   (Q)uit");
}

void nihilist::show_cipher(){
  int i;

  /* Print the row/column numbers
  */

  for(i = 0; i < period; i++)
    (void)put_char((i+1)%10 + '0', 2*i+3, 0);
  
  for(i = 0; i < clen; i++)
    (void)put_char((i+1)%10 + '0', 0, i+2);

  /* Print the cipher
  */

  for(i = 0; i < length; i++){
    (void)put_char(cipher[i], (i%period)*2+3, (i/period) + 2);
  }
}

void nihilist::show_key(){ }

void nihilist::move_stuff(){
  char temp_str[STRINGLENGTH];
  int column1, column2, i;

  prompt("Interchange which two columns/rows? (ex: 1,2) ");
  read_line(temp_str);
  if(sscanf(temp_str, "%d,%d", &column1, &column2) != 2);
  else if(column1 <= period && column2 <= period && column1 > 0 && column2 > 0){
    column1--, column2--;
    interchange_columns(column1, column2);
    interchange_rows(column1, column2);

    i = key[column1];
    key[column1] = key[column2];
    key[column2] = i;
  }
  
  else{
    msgerror("Bad column number.");
  }
}

void nihilist::decipher(char *string){
  strcpy(string, cipher);
}

void nihilist::copy_key(char *string){
  int i;

  for(i = 0; i < period; i++)
    string[i] = (char) (key[i] + '0');
  
  string[period] = '\0';
}

void nihilist::read_key(FILE *fptr){
  char temp_str[STRINGLENGTH];
  int i;

  fgets(temp_str, STRINGLENGTH, fptr);

  for(i = 0; i < period; i++)
    key[i] = temp_str[i] - '0';
}

void nihilist::get_cipher(char *string){
  horiz2vert();
  strcpy(string, cipher);
  vert2horiz();
}
