/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

void transposition::interchange_columns(int column1, int column2){
  int i;
  char *tempcipher;

  tempcipher = strdup(cipher);

  for(i = 0; i < clen; i++){
    cipher[i*period + column1] = tempcipher[i*period+column2];
    cipher[i*period + column2] = tempcipher[i*period+column1];
  }

  free(tempcipher);
}

void transposition::interchange_rows(int row1, int row2){
  int i;
  char *tempcipher;

  tempcipher = strdup(cipher);

  for(i = 0; i < period; i++){
    cipher[row1*period+i] = tempcipher[row2*period+i];
    cipher[row2*period+i] = tempcipher[row1*period+i];
  }

  free(tempcipher);
}

void transposition::vert2horiz(){
  char *tempcipher;
  int i;

  tempcipher = strdup(cipher);

  i=0;
  while(i < length){
    cipher[(i/clen) + (i%clen)*period] = tempcipher[i];
    i++;
  }
  cipher[i] = '\0';

  free(tempcipher);
}

void transposition::horiz2vert(){
  char *tempcipher;
  int i;

  tempcipher = strdup(cipher);

  i=0;
  while(i < length){
    cipher[(i%period)*clen + i/period] = tempcipher[i];
    i++;
  }

  free(tempcipher);
}

void transposition::rotate_column(int column, int amount){
  char *tempcipher;
  int i;

  tempcipher = strdup(cipher);

  i = 0;
  while(i < length){
    cipher[i*period + column] = tempcipher[(i*period+column+amount)%length];
    i += period;
  }

  free(tempcipher);
}

void transposition::undo(){
  strcpy(cipher, ocipher);
}
