/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

/*
 * Note:  if you want to bind \n or \r, use M_ENTER_S so that it will work
 * correctly under both ncurses and S-Lang
 */

struct binding_t OpGeneric[] = {
  { "select-entry",	OP_GENERIC_SELECT_ENTRY,	M_ENTER_S },
  { "next-entry",	OP_GENERIC_NEXT_ENTRY,		"j" },
  { "previous-entry",	OP_GENERIC_PREVIOUS_ENTRY,	"k" },
  { "last-entry",	OP_GENERIC_LAST_ENTRY,		"*" },
  { "first-entry",	OP_GENERIC_FIRST_ENTRY,		"=" },
  { "next-page",	OP_NEXT_PAGE,			"z" },
  { "previous-page",	OP_PREVIOUS_PAGE,		"Z" },
  { "help",		OP_HELP,			"?" },
  { "refresh",		OP_REDRAW,			"\\cl" },
  { "top-of-page",	OP_TOP_OF_PAGE,			"H" },
  { "middle-of-page",	OP_MIDDLE_OF_PAGE,		"M" },
  { "bottom-of-page",	OP_BOTTOM_OF_PAGE,		"L" },
  { "exit",		OP_GENERIC_EXIT,		"q" },
  { "search",		OP_SEARCH,			"/" },
  { NULL,		0,				NULL }
};

struct binding_t OpMain[] = {
  { "create-alias",		OP_CREATE_ALIAS,		"a" },
  { "bounce-message",		OP_BOUNCE_MESSAGE,		"b" },
  { "bottom-of-page",		OP_BOTTOM_OF_PAGE,		"B" },
  { "change-folder",		OP_MAIN_CHANGE_FOLDER,		"c" },
  { "copy-message",		OP_MAIN_COPY_MESSAGE,		"C" },
  { "delete-message",		OP_DELETE,			"d" },
  { "delete-pattern",		OP_MAIN_DELETE_PATTERN,		"D" },
  { "delete-thread",		OP_DELETE_THREAD,		"\\cd" },
  { "forward-message",		OP_FORWARD_MESSAGE,		"f" },
  { "flag-message",		OP_FLAG_MESSAGE,		"F" },
  { "forget-passphrase",	OP_FORGET_PASSPHRASE,		"\\cf" },
  { "group-reply",		OP_GROUP_REPLY,			"g" },
  { "fetch-mail",		OP_MAIN_FETCH_MAIL,		"G" },
  { "display-headers",		OP_DISPLAY_HEADERS,		"h" },
  { "top-of-page",		OP_TOP_OF_PAGE,			"H" },
  { "next-undeleted",		OP_MAIN_NEXT_UNDELETED,		"j" },
  { "next-message",		OP_MAIN_NEXT_MESSAGE,		"J" },
  { "previous-undeleted",	OP_MAIN_PREVIOUS_UNDELETED,	"k" },
  { "previous-message",		OP_MAIN_PREVIOUS_MESSAGE,	"K" },
  { "limit",			OP_MAIN_LIMIT,			"l" },
  { "redraw-screen",		OP_REDRAW,			"\\cl" },
  { "list-reply",		OP_LIST_REPLY,			"L" },
  { "mail",			OP_MAIL,			"m" },
  { "middle-of-page",		OP_MIDDLE_OF_PAGE,		"M" },
  { "toggle-new",		OP_TOGGLE_NEW,			"N" },
  { "next-thread",		OP_MAIN_NEXT_THREAD,		"\\cn" },
  { "quit",			OP_QUIT,			"q" },
  { "reply",			OP_REPLY,			"r" },
  { "sort-messages",		OP_MAIN_SORT_MESSAGES,		"o" },
  { "print-message",		OP_PRINT,			"p" },
  { "previous-thread",		OP_MAIN_PREVIOUS_THREAD,	"\\cp" },
  { "recall-message",		OP_RECALL_MESSAGE,		"R" },
  { "save-message",		OP_MAIN_SAVE_MESSAGE,		"s" },
  { "search-body",		OP_MAIN_SEARCH_BODY,		"S" },
  { "tag-message",		OP_TAG_MESSAGE,			"t" },
  { "tag-pattern",		OP_MAIN_TAG_PATTERN,		"T" },
  { "untag-pattern",		OP_MAIN_UNTAG_PATTERN,		"\\ct" },
  { "undelete-message",		OP_UNDELETE,			"u" },
  { "undelete-pattern",		OP_MAIN_UNDELETE_PATTERN,	"U"},
  { "browse-url",		OP_BROWSE_URL,			"\\cb" },
  { "view-attachments",		OP_VIEW_ATTACHMENTS,		"v" },
  { "set-flag",			OP_MAIN_SET_FLAG,		"w" },
  { "clear-flag",		OP_MAIN_CLEAR_FLAG,		"W" },
  { "exit",			OP_MAIN_EXIT,			"x" },
  { "next-page",		OP_NEXT_PAGE,			"z" },
  { "previous-page",		OP_PREVIOUS_PAGE,		"Z" },
  { "display-message",		OP_DISPLAY_MESSAGE,		M_ENTER_S },
  { "first-message",		OP_MAIN_FIRST_MESSAGE,		"=" },
  { "last-message",		OP_MAIN_LAST_MESSAGE,		"*" },
  { "enter-command",		OP_ENTER_COMMAND,		":" },
  { "sync-mailbox",		OP_MAIN_SYNC_FOLDER,		"$" },
  { "tag-prefix",		OP_MAIN_TAG_PREFIX,		";" },
  { "search",			OP_MAIN_SEARCH,			"/" },
  { "search-reverse",		OP_MAIN_SEARCH_REVERSE,		"\\e/" },
  { "help",			OP_HELP,			"?" },
  { "invoke-subshell",		OP_SUBSHELL,			"!" },
  { "display-address",		OP_DISPLAY_ADDRESS,		"%" },
  { "pipe-message",		OP_PIPE_MESSAGE,		"|" },
  { "undelete-thread",		OP_UNDELETE_THREAD,		"\\cu" },
  { "next-new",			OP_MAIN_NEXT_NEW,		"\t" },
  { "jump",			OP_MAIN_JUMP,			NULL },
  { "next-unread",		OP_MAIN_NEXT_UNREAD,		NULL },
  { "previous-new",		OP_MAIN_PREV_NEW,		NULL },
  { "previous-unread",		OP_MAIN_PREV_UNREAD,		NULL },
  { NULL,			0,				NULL }
};

struct binding_t OpPager[] = {
  { "create-alias",	OP_CREATE_ALIAS,		"a" },
  { "bounce-message",	OP_BOUNCE_MESSAGE,		"b" },
  { "browse-url",	OP_BROWSE_URL,			"\\cb" },
  { "change-folder",	OP_MAIN_CHANGE_FOLDER,		"c" },
  { "copy-message",	OP_MAIN_COPY_MESSAGE,		"C" },
  { "delete-message",	OP_DELETE,			"d" },
  { "delete-thread",	OP_DELETE_THREAD,		"\\cd" },
  { "forward-message",	OP_FORWARD_MESSAGE,		"f" },
  { "flag-message",	OP_FLAG_MESSAGE,		"F" },
  { "forget-passphrase",OP_FORGET_PASSPHRASE,		"\\cf" },
  { "group-reply",	OP_GROUP_REPLY,			"g" },
  { "display-headers",	OP_DISPLAY_HEADERS,		"h" },
  { "exit",		OP_PAGER_EXIT,			"i" },
  { "next-undeleted",	OP_MAIN_NEXT_UNDELETED,		"j" },
  { "next-message",	OP_MAIN_NEXT_MESSAGE,		"J" },
  { "previous-undeleted",OP_MAIN_PREVIOUS_UNDELETED,	"k" },
  { "previous-message",	OP_MAIN_PREVIOUS_MESSAGE,	"K" },
  { "list-reply",	OP_LIST_REPLY,			"L" },
  { "redraw-screen",	OP_REDRAW,			"\\cl" },
  { "mail",		OP_MAIL,			"m" },
  { "mark-as-new",	OP_TOGGLE_NEW,			"N" },
  { "next-thread",	OP_MAIN_NEXT_THREAD,		"\\cn" },
  { "print-message",	OP_PRINT,			"p" },
  { "previous-thread",	OP_MAIN_PREVIOUS_THREAD,	"\\cp" },
  { "reply",		OP_REPLY,			"r" },
  { "recall-message",	OP_RECALL_MESSAGE,		"R" },
  { "save-message",	OP_MAIN_SAVE_MESSAGE,		"s" },
  { "tag-message",	OP_TAG_MESSAGE,			"t" },
  { "toggle-quoted",	OP_PAGER_HIDE_QUOTED,		"T" },
  { "undelete-message",	OP_UNDELETE,			"u" },
  { "undelete-thread",	OP_UNDELETE_THREAD,		"\\cu" },
  { "view-attachments",	OP_VIEW_ATTACHMENTS,		"v" },
  { "help",		OP_HELP,			"?" },
  { "next-page",	OP_NEXT_PAGE,			" " },
  { "previous-page",	OP_PREVIOUS_PAGE,		"-" },
  { "next-line",	OP_PAGER_NEXT_LINE,		M_ENTER_S },
  { "top",		OP_PAGER_TOP,			"^" },
  { "bottom",		OP_PAGER_BOTTOM,		"$" },
  { "invoke-subshell",	OP_SUBSHELL,			"!" },
  { "search",		OP_PAGER_SEARCH,		"/" },
  { "display-address",	OP_DISPLAY_ADDRESS,		"%" },
  { "pipe-message",	OP_PIPE_MESSAGE,		"|" },
  { "next-new",		OP_MAIN_NEXT_NEW,		"\t" },
  { "enter-command",	OP_ENTER_COMMAND,		":" },
  { "half-up",		OP_PAGER_HALF_UP,		NULL },
  { "half-down",	OP_PAGER_HALF_DOWN,		NULL },
  { "previous-line",	OP_PAGER_PREVIOUS_LINE,		NULL },
  { "next-unread",	OP_MAIN_NEXT_UNREAD,		NULL },
  { "previous-new",	OP_MAIN_PREV_NEW,		NULL },
  { "previous-unread",	OP_MAIN_PREV_UNREAD,		NULL },
  { "display-message",	OP_DISPLAY_MESSAGE,		NULL },
  { NULL,		0,				NULL }
};

struct binding_t OpAttach[] = {
  { "print-entry",	OP_PRINT,		"p" },
  { "save-entry",	OP_ATTACH_SAVE_ENTRY,	"s" },
  { "pipe-entry",	OP_ATTACH_PIPE_ENTRY,	"|" },
  { "view-mailcap",	OP_ATTACH_VIEW_MAILCAP,	"m" },
  { "view-text",	OP_ATTACH_VIEW_TEXT,	"t" },
  { NULL,		0,			NULL }
};

struct binding_t OpSend[] = {
  { "help",		OP_HELP,			"?" },
  { "edit-to",		OP_SEND_EDIT_TO,		"t" },
  { "edit-cc",		OP_SEND_EDIT_CC,		"c" },
  { "edit-bcc",		OP_SEND_EDIT_BCC,		"b" },
  { "edit-subject",	OP_SEND_EDIT_SUBJECT,		"s" },
  { "edit-message",	OP_SEND_EDIT_MESSAGE,		"e" },
  { "edit-headers",	OP_SEND_EDIT_HEADERS,		"E" },
  { "send-message",	OP_SEND_SEND_MESSAGE,		M_ENTER_S },
  { "abort-message",	OP_SEND_ABORT_MESSAGE,		"n" },
  { "ispell",		OP_SEND_ISPELL,			"i" },
  { "pgp-menu",		OP_SEND_PGP_MENU,		"p" },
  { "attach-file",	OP_SEND_ATTACH_FILE,		"a" },
  { "redraw-screen",	OP_REDRAW,			"\\cl" },
  { "postpone-message",	OP_SEND_POSTPONE_MESSAGE,	"P" },
  { "edit-fcc",		OP_SEND_EDIT_FCC,		"f" },
  { "enter-command",	OP_ENTER_COMMAND,		":" },
  { NULL,		0,				NULL }
};

struct binding_t OpSendAttach[] = {
  { "delete-entry",	OP_DELETE,				"d" },
  { "enter-description",OP_SENDATTACH_ENTER_DESCRIPTION,	"s" },
  { "add-attachment",	OP_SENDATTACH_ADD_ATTACHMENT,		"a" },
  { "edit-type",	OP_SENDATTACH_EDIT_TYPE,		"\\ct" },
  { "edit-encoding",	OP_SENDATTACH_EDIT_ENCODING,		"\\ce" },
  { NULL,		0,					NULL }
};

struct binding_t OpPost[] = {
  { "delete-entry",	OP_DELETE,	NULL },
  { "undelete-entry",	OP_UNDELETE,	NULL },
  { NULL,		0,		NULL }
};

