/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

void bindkey (char *, int, int, char *);
int dokey (int);
int parsekey (char **);

enum {
  MENU_MAIN,
  MENU_PAGER,
  MENU_ATTACH,
  MENU_FOLDER,
  MENU_ALIAS,
  MENU_SEND,
  MENU_POST,
  MENU_SENDATTACH,
  MENU_URL,
  MENU_MAX
};

struct binding_t {
  char *name;	/* name of the function */
  short op;	/* function id number */
  char *seq;	/* default key binding */
};

/* entry in the keymap tree */
struct keymap_t {
  short key;             /* key pressed */
  short op;              /* operation to perform */
  char *macro;           /* macro expansion (op == OP_MACRO) */
  struct keymap_t *seq;  /* next key in sequence (child node) */
  struct keymap_t *next; /* next key in map */
};

/* the keymap trees (one for each menu) */
extern struct keymap_t *Keymaps[];

/* dokey() records the last real key pressed  */
extern int LastKey;

extern struct binding_t OpGeneric[];
extern struct binding_t OpPost[];
extern struct binding_t OpMain[];
extern struct binding_t OpSendAttach[];
extern struct binding_t OpAttach[];
extern struct binding_t OpPager[];
extern struct binding_t OpSend[];

#include "keymap_defs.h"
