/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is named mutt_menu.h so it doesn't collide with ncurses menu.h
 */

typedef struct menu_t {
  char *title;        /* the title of this menu */
  short current;      /* current entry */
  short redraw;
  short menu;         /* menu definition for keymap entries. */
  short max;          /* the number of entries in the menu */
  
  /* callback to generate an index line for the requested element */
  void (*makeEntry) (char *, int, size_t);
  
  /* how to search the menu */
  int (*search) (const char *, struct menu_t *);

  /* the following are used only by mutt_menuLoop() */
  short top;          /* entry that is the top of the current page */
  short oldcurrent;   /* for driver use only. */
} MUTTMENU;

enum {
  REDRAW_FULL = 1,
  REDRAW_INDEX,
  REDRAW_MOTION,
  REDRAW_CURRENT
};

MUTTMENU *mutt_newMenu (const char *);
void mutt_menuDestroy (MUTTMENU **);
int mutt_menuLoop (MUTTMENU *);
