/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include <string.h>

/*
 * Like strtok(), except that quoted phrases are returned as one token
 */
char *strtokq (char *s, char *tokens)
{
  static char *p;
  char quote_char = 0, *r, *t;
  
  if (s)
  {
    /* initial call. */
    p = s;
  }

  if (!p)
    return NULL;

  if (*p == '\'' || *p == '\"')
  {
    quote_char = *p;
    p++;
    r = p;
    while (*p && *p != quote_char)
      p++;
    if (*p)
    {
      *p++ = 0;
      if (*p)
	while (strchr (tokens, *p) != NULL)
	  p++;
      if (! *p)
	p = NULL; /* end of string */
    }
    else
      p = NULL;
    return (r);
  }
  r = p;
  if ((t = strpbrk (p, tokens)))
  {
    *t++ = 0;
    while (*t && strchr(tokens, *t) != 0)
      t++;
    p = t;
    return (r);
  }
  else
    p = NULL; /* all done */
  return (r);
}
