/*
 * Copyright (C) 1996,1997 Michael R. Elkins.
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include "muttlib.h"

#include <unistd.h>
#include <stdlib.h>

/*
 * Invokes a commmand on a pipe and optionally connects its stdin and stdout
 * to the specified handles.
 */
int mutt_create_filter (const char *cmd, FILE **in, FILE **out)
{
  int pin[2], pout[2];

  if (in)
  {
    *in = 0;
    if (pipe (pin) == -1)
      return (-1);
  }
  if (out)
  {
    *out = 0;
    if (pipe (pout) == -1)
      return (-1);
  }

  if (fork () == 0)
  {
    if (in)
    {
      close (pin[1]);
      close (0);
      dup (pin[0]);
      close (pin[0]);
    }
    if (out)
    {
      close (pout[0]);
      close (1);
      dup (pout[1]);
      close (pout[1]);
    }
    _exit (system (cmd));
  }

  if (out)
  {
    close (pout[1]);
    *out = fdopen (pout[0], "r");
  }
  if (in)
  {
    close (pin[0]);
    *in = fdopen (pin[1], "w");
  }

  return (0);
}
