/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#define HELP_C

#include "mutt.h"
#include "mutt_curses.h"
#include "keymap.h"

static struct binding_t *help_lookupFunction (int op, int menu)
{
  int i;

  switch (menu)
  {
    case MENU_MAIN:

      for (i=0; OpMain[i].name; i++)
	if (OpMain[i].op == op) return (&OpMain[i]);
      break;

    case MENU_SEND:

      for (i=0; OpSend[i].name; i++)
	if (OpSend[i].op == op) return (&OpSend[i]);
      break;

    case MENU_PAGER:

      for (i=0; OpPager[i].name; i++)
	if (OpPager[i].op == op) return (&OpPager[i]);
      break;

    default:

      for (i=0; OpGeneric[i].name; i++)
	if (OpGeneric[i].op == op) return(&OpGeneric[i]);    

      if (menu == MENU_ATTACH)
      {
	for (i=0; OpAttach[i].name; i++)
	  if (OpAttach[i].op == op) return (&OpAttach[i]);
      }
      else if (menu == MENU_SENDATTACH)
      {
	for (i=0; OpSendAttach[i].name; i++)
	  if (OpSendAttach[i].op == op) return (&OpSendAttach[i]);
      }
      else if (menu == MENU_POST)
      {
	for (i=0; OpPost[i].name; i++)
	  if (OpPost[i].op == op) return (&OpPost[i]);
      }
  }
  return 0;
}

static char *help_keyname (int c)
{
  static char buf[3];

  switch (c)
  {
    case '\033':
      return "ESC";
    case ' ':
      return "SPC";
    case '\n':
    case '\r':
      return "RET";
    case '\t':
      return "TAB";
    case KEY_UP:
      return "Up";
    case KEY_DOWN:
      return "Down";
    case KEY_LEFT:
      return "Left";
    case KEY_RIGHT:
      return "Right";
    case KEY_NPAGE:
      return "PageDn";
    case KEY_PPAGE:
      return "PageUp";
    case KEY_BACKSPACE:
      return "BackSpace";
    case KEY_HOME:
      return "Home";
    case KEY_END:
      return "End";
    case 127:
      return "DEL";
  }

  if (iscntrl (c))
  {
    buf[0] = '^';
    buf[1] = c + '@';
    buf[2] = 0;
    return (buf);
  }
  else
  {
    snprintf (buf, sizeof(buf), "%c", (unsigned char)c);
    return buf;
  }
}

void print_help (int menu, struct keymap_t *map, char *pfx, FILE *fp)
{
  char buf[SHORT_STRING];
  struct binding_t *b;

  while (map)
  {
    if (map->seq)
    {
      snprintf (buf, sizeof(buf), "%s %s", pfx, help_keyname (map->key));
      print_help (menu, map->seq, buf, fp);
    }
    else if (map->op == OP_MACRO)
      fprintf (fp, "%s %s\t%-20s\t%s\n", pfx, help_keyname (map->key), "macro",
	       map->macro);
    else if (map->op != OP_NULL)
    {
      b = help_lookupFunction (map->op, menu);
      fprintf (fp, "%s %s\t%-20s\t%s\n", pfx, help_keyname (map->key), b->name,
	       HelpStrings[b->op]);
    }
    map = map->next;
  }
}

void ci_help (int menu)
{
  char t[_POSIX_PATH_MAX];
  char banner[SHORT_STRING];
  char *desc;
  struct keymap_t *k;
  FILE *f;

  mutt_mktemp (t);
  if ((f = fopen (t, "w")) == NULL)
  {
    beep ();
    mutt_error("Could not create temp file!");
    return;
  }
  switch (menu)
  {
    case MENU_PAGER:
      desc="internal-pager";
      break;
    case MENU_MAIN:
      desc="main-menu";
      break;
    case MENU_ATTACH:
      desc="attach-menu";
      break;
    case MENU_SEND:
      desc="send-menu";
      break;
    case MENU_FOLDER:
      desc="folder-menu";
      break;
    case MENU_ALIAS:
      desc="alias-menu";
      break;
    case MENU_SENDATTACH:
      desc="send-attach-menu";
      break;
    case MENU_URL:
      desc="url-menu";
      break;
    case MENU_POST:
      desc="postponed-menu";
      break;
    default:
      desc="<UNKNOWN MENU>";
  }
  snprintf (banner, sizeof (banner), "Help for %s", desc);
  k = Keymaps[menu];
  print_help (menu, Keymaps[menu], "", f);
  fclose (f);

  mutt_do_pager (banner, t);
}
