#include "config.h"

#ifndef HAVE_SNPRINTF

#include <ctype.h>
#include <sys/types.h>

#define HAVE_VARARGS_H

/* #define HAVE_STDARG_H */
/**************************************************************
 * Original:
 * Patrick Powell Tue Apr 11 09:48:21 PDT 1995
 * A bombproof version of doprnt (dopr) included.
 * Sigh.  This sort of thing is always nasty do deal with.  Note that
 * the version here does not include floating point...
 *
 * snprintf() is used instead of sprintf() as it does limit checks
 * for string length.  This covers a nasty loophole.
 *
 * The other functions are there to prevent NULL pointers from
 * causing nast effects.
 *
 * More Recently:
 *  Brandon Long blong1@ichips.intel.com 9/15/96 for mutt 0.43
 *  This was ugly.  It is still ugly.  I opted out of floating point
 *  numbers, but the formatter understands just about everything
 *  from the normal C string format, at least as far as I can tell from
 *  the Solaris 2.5 printf(3S) man page.
 *
 **************************************************************/


/* varargs declarations: */

#if defined(HAVE_STDARG_H)
# include <stdarg.h>
# define HAVE_STDARGS    /* let's hope that works everywhere (mj) */
# define VA_LOCAL_DECL   va_list ap
# define VA_START(f)     va_start(ap, f)
# define VA_SHIFT(v,t)  ;   /* no-op for ANSI */
# define VA_END          va_end(ap)
#else
# if defined(HAVE_VARARGS_H)
#  include <varargs.h>
#  undef HAVE_STDARGS
#  define VA_LOCAL_DECL   va_list ap
#  define VA_START(f)     va_start(ap)      /* f is ignored! */
#  define VA_SHIFT(v,t) v = va_arg(ap,t)
#  define VA_END        va_end(ap)
# else
/*XX ** NO VARARGS ** XX*/
# endif
#endif

int snprintf (char *str, size_t count, const char *fmt, ...);
int vsnprintf (char *str, size_t count, const char *fmt, va_list arg);
void setproctitle( char *fmt, ... );

static void dopr(char *buffer, size_t maxlen, const char *format, va_list args);
static void fmtstr(char *buffer, int *currlen, int maxlen,
		   char *value, int flags, int min, int max);
static void fmtint(char *buffer, int *currlen, int maxlen,
		   long value, int base, int min, int max, int flags);
#if 0
static void dostr(char *buffer, int *currlen, int maxlen, char *str);
#endif
static void dopr_outch(char *buffer, int *currlen, int maxlen, char c );

int vsnprintf(char *str, size_t count, const char *fmt, va_list args)
{
  str[0] = 0;
  dopr(str, count, fmt, args);
  return(strlen(str));
}

/* VARARGS3 */
#ifdef HAVE_STDARGS
int snprintf (char *str,size_t count,const char *fmt,...)
#else
int snprintf (va_alist) va_dcl
#endif
{
#ifndef HAVE_STDARGS
  char *str;
  size_t count;
  char *fmt;
#endif
  VA_LOCAL_DECL;
    
  VA_START (fmt);
  VA_SHIFT (str, char *);
  VA_SHIFT (count, size_t );
  VA_SHIFT (fmt, char *);
  (void) vsnprintf(str, count, fmt, ap);
  VA_END;
  return(strlen(str));
}

/*
 * dopr(): poor man's version of doprintf
 */

/* format read states */
#define DP_S_DEFAULT 0
#define DP_S_FLAGS   1
#define DP_S_MIN     2
#define DP_S_DOT     3
#define DP_S_MAX     4
#define DP_S_MOD     5
#define DP_S_CONV    6
#define DP_S_DONE    7

/* format flags - Bits */
#define DP_F_MINUS 1
#define DP_F_PLUS  2
#define DP_F_SPACE 4
#define DP_F_NUM   8
#define DP_F_ZERO  16
#define DP_F_UP    32

/* Conversion Flags */
#define DP_C_SHORT   1
#define DP_C_LONG    2
#define DP_C_LDOUBLE 3

#define char_to_int(p) (p - '0')

static void dopr(char *buffer, size_t maxlen, const char *format, va_list args)
{
  char ch;
  long value;
  long double fvalue;
  char *strvalue;
  int min;
  int max;
  int state;
  int flags;
  int cflags;
  int currlen;
  
/*   output = buffer; */
  state = DP_S_DEFAULT;
  currlen = flags = cflags = min = max = 0;
  ch = *format++;

  while(state != DP_S_DONE){
    if ((ch == '\0') || (currlen >= maxlen)) state = DP_S_DONE;
    switch(state) {
    case DP_S_DEFAULT:
      if (ch == '%') state = DP_S_FLAGS;
      else dopr_outch(buffer,&currlen,maxlen,ch);
      ch = *format++;
      break;
    case DP_S_FLAGS:
      switch (ch) {
      case '-':
	flags |= DP_F_MINUS;
        ch = *format++;
	break;
      case '+':
	flags |= DP_F_PLUS;
        ch = *format++;
	break;
      case ' ':
	flags |= DP_F_SPACE;
        ch = *format++;
	break;
      case '#':
	flags |= DP_F_NUM;
        ch = *format++;
	break;
      case '0':
	flags |= DP_F_ZERO;
        ch = *format++;
	break;
      default:
	state = DP_S_MIN;
	break;
      }
      break;
    case DP_S_MIN:
      if (isdigit(ch)) {
	min = 10*min + char_to_int(ch);
	ch = *format++;
      } else if (ch == '*') {
	min = va_arg(args, int);
	ch = *format++;
	state = DP_S_DOT;
      } else state = DP_S_DOT;
      break;
    case DP_S_DOT:
      if (ch == '.') {
	state = DP_S_MAX;
	ch = *format++;
      } else state = DP_S_MOD;
      break;
    case DP_S_MAX:
      if (isdigit(ch)) {
	max = 10*max + char_to_int(ch);
	ch = *format++;
      } else if (ch == '*') {
	max = va_arg(args, int);
	ch = *format++;
	state = DP_S_MOD;
      } else state = DP_S_MOD;
      break;
    case DP_S_MOD:
      /* Currently, we don't support Long Long, bummer */
      switch (ch) {
      case 'h':
	cflags = DP_C_SHORT;
	ch = *format++;
	break;
      case 'l':
	cflags = DP_C_LONG;
	ch = *format++;
	break;
      case 'L':
	cflags = DP_C_LDOUBLE;
	ch = *format++;
	break;
      default:
	break;
      }
      state = DP_S_CONV;
      break;
    case DP_S_CONV:
      switch (ch) {
      case 'd':
      case 'i':
	if (cflags == DP_C_SHORT) 
	  value = va_arg(args, short int);
	else if (cflags == DP_C_LONG)
	  value = va_arg(args, long int);
	else
	  value = va_arg(args, int);
	fmtint(buffer,&currlen,maxlen,value,10,min,max,flags);
	break;
      case 'o':
	flags &= ~DP_F_PLUS;
	if (cflags == DP_C_SHORT)
	  value = va_arg(args, unsigned short int);
	else if (cflags == DP_C_LONG)
	  value = va_arg(args, unsigned long int);
	else
	  value = va_arg(args, unsigned int);
	fmtint(buffer,&currlen,maxlen,value,8,min,max,flags);
	break;
      case 'u':
	flags &= ~DP_F_PLUS;
	if (cflags == DP_C_SHORT)
	  value = va_arg(args, unsigned short int);
	else if (cflags == DP_C_LONG)
	  value = va_arg(args, unsigned long int);
	else
	  value = va_arg(args, unsigned int);
	fmtint(buffer,&currlen,maxlen,value,10,min,max,flags);
	break;
      case 'X':
	flags |= DP_F_UP;
      case 'x':
	flags &= ~DP_F_PLUS;
	if (cflags == DP_C_SHORT)
	  value = va_arg(args, unsigned short int);
	else if (cflags == DP_C_LONG)
	  value = va_arg(args, unsigned long int);
	else
	  value = va_arg(args, unsigned int);
	fmtint(buffer,&currlen,maxlen,value,16,min,max,flags);
	break;
      case 'f':
	if (cflags == DP_C_LDOUBLE)
	  fvalue = va_arg(args, long double);
	else
	  fvalue = va_arg(args, double);
	/* um, floating point? */
	break;
      case 'E':
	flags |= DP_F_UP;
      case 'e':
	if (cflags == DP_C_LDOUBLE)
	  fvalue = va_arg(args, long double);
	else
	  fvalue = va_arg(args, double);
	break;
      case 'G':
	flags |= DP_F_UP;
      case 'g':
	if (cflags == DP_C_LDOUBLE)
	  fvalue = va_arg(args, long double);
	else
	  fvalue = va_arg(args, double);
	break;
      case 'c':
	dopr_outch(buffer,&currlen,maxlen,va_arg(args,int));
	break;
      case 's':
	strvalue = va_arg(args, char *);
	if (max == 0) max = maxlen; /* ie, no max */
	fmtstr(buffer,&currlen,maxlen,strvalue,flags,min,max);
	break;
      case 'p':
	strvalue = va_arg(args, void *);
	fmtint(buffer,&currlen,maxlen,(long) strvalue,16,min,max,flags);
	break;
      case 'n':
	if (cflags == DP_C_SHORT) {
	  short int *num;
	  num = va_arg(args, short int *);
	  *num = currlen;
        } else if (cflags == DP_C_LONG) {
	  long int *num;
	  num = va_arg(args, long int *);
	  *num = currlen;
        } else {
	  int *num;
	  num = va_arg(args, int *);
	  *num = currlen;
        }
	break;
      case '%':
	dopr_outch(buffer,&currlen,maxlen,ch);
	break;
      case 'w':
	/* not supported yet, treat as next char */
	ch = *format++;
	break;
      default:
	/* Unknown, skip */
	break;
      }
      ch = *format++;
      state = DP_S_DEFAULT;
      flags = cflags = min = max = 0;
      break;
    case DP_S_DONE:
      break;
    default:
      /* hmm? */
      break; /* some picky compilers need this */
    }
  }
  if (currlen < maxlen - 1) buffer[currlen] = '\0';
  else buffer[maxlen - 1] = '\0';
}

static void fmtstr(char *buffer, int *currlen, int maxlen,
		   char *value, int flags, int min, int max)
{
  int padlen, strln;     /* amount to pad */
  int cnt = 0;
  
  if( value == 0 ){
    value = "<NULL>";
  }
  for(strln = 0; value[strln]; ++strln ); /* strlen */
  padlen = min - strln;
  if (padlen < 0) padlen = 0;
  if (flags & DP_F_MINUS) padlen = -padlen; /* Left Justify */
  while ((padlen > 0) && (cnt < max)) {
    dopr_outch(buffer,currlen,maxlen,' ');
    --padlen;
    ++cnt;
  }
  while (*value && (cnt < max)) {
    dopr_outch(buffer,currlen,maxlen,*value++);
    ++cnt;
  }
  while ((padlen < 0) && (cnt < max)) {
    dopr_outch(buffer,currlen,maxlen,' ');
    ++padlen;
    ++cnt;
  }
}

/* Have to handle DP_F_NUM (ie 0x and 0 alternates) */

static void fmtint(char *buffer, int *currlen, int maxlen,
		   long value, int base, int min, int max, int flags)
{
  int signvalue = 0;
  unsigned long uvalue;
  char convert[20];
  int place = 0;
  int padlen = 0; /* amount to pad */
  int caps = 0;
  
  /* DEBUGP(("value 0x%x, base %d, dosign %d, ljust %d, len %d, zpad %d\n",
     value, base, dosign, ljust, len, zpad )); */
  uvalue = value;
  if (flags & DP_F_PLUS) {  /* Do a sign (+/i) */
    if( value < 0 ) {
      signvalue = '-';
      uvalue = -value;
    }
  }
  if (flags & DP_F_UP) caps = 1; /* Should characters be upper case? */

  do {
    convert[place++] =
      (caps? "0123456789ABCDEF":"0123456789abcdef")
      [uvalue % (unsigned)base  ];
    uvalue = (uvalue / (unsigned)base );
  } while(uvalue && (place < 20));
  if (place == 20) place--;
  convert[place] = 0;
  padlen = min - place;
  if (padlen < 0) padlen = 0;
  if (flags & DP_F_MINUS) padlen = -padlen; /* Left Justifty */
  /* DEBUGP(( "str '%s', place %d, sign %c, padlen %d\n",
     convert,place,signvalue,padlen)); */
  if ((flags & DP_F_ZERO) && (padlen > 0)) {
    if (signvalue) {
      dopr_outch(buffer,currlen,maxlen,signvalue);
      --padlen;
      signvalue = 0;
    }
    while( padlen > 0 ){
      dopr_outch(buffer,currlen,maxlen,'0');
      --padlen;
    }
  }
  while( padlen > 0 ) {
    dopr_outch(buffer,currlen,maxlen,' ');
    --padlen;
  }
  if (signvalue) dopr_outch(buffer,currlen,maxlen,signvalue);
  while (place > 0) dopr_outch(buffer,currlen,maxlen,convert[--place]);
  while (padlen < 0) {
    dopr_outch(buffer,currlen,maxlen,' ');
    ++padlen;
  }
}

#if 0
static void dostr(char *buffer, int *currlen, int maxlen, char *str)
{
  while(*str) dopr_outch(buffer,currlen,maxlen,*str++);
}
#endif

static void dopr_outch(char *buffer, int *currlen, int maxlen, char c)
{
#if 0
  if (iscntrl(c) && c != '\n' && c != '\t') {
    c = '@' + (c & 0x1F);
    if (*currlen < maxlen)
      buffer[(*currlen)++] = '^';
  }
#endif
  if (*currlen < maxlen)
    buffer[(*currlen)++] = c;
}

#endif /* !HAVE_SNPRINTF */
