#include <stdio.h>
#include <stdlib.h>
#include "dstypes.h"

#define EFE 3

typedef
struct b4 {
   unsigned        a0:4;
   unsigned        a1:4;
}               b4;
static int      bt[16], ft[16], rt[16];
typedef
struct us4 {
   unsigned        t:2;
   unsigned        a:4;
   unsigned        b:2;
}               us4;
void            writehexline(char *c, int i);

typedef
union swp {
   char            c;
   b4              i2;
   us4             i1;
}               swp;

static swp      hold;

int 
gb4(b4 * a, int b, int zo1)
{
   int             i;
   char           *cp;
   void           *vp;
   cp = vp = a;
   cp += b;
   a = vp = cp;
   if (zo1)
      return (int) a->a1;
   return (int) a->a0;
}

void 
pb4(b4 * a, int b, int zo1, int c)
{
   /* b char postion zo1 zero or odd position c 4 bit vale */
   int             i;
   char           *cp;
   void           *vp;
   cp = vp = a;
   cp += b;
   a = vp = cp;
   c = 0xf & c;			/* make 4 bits max */
   if (zo1)
      a->a1 = c;
   else
      a->a0 = c;
}





/****************************/
void
rem_tab4(int *prtb, int *pftb, int *pbtb)
{
   /*
    * this code builds the S table for a 4 bit look up table the
    * lookup take with proper choice of remainder values can be one
    * of any complete cycle mappings of the 4 bit wide look up
    * table. since 16 number of slots zero can map to 15
    * values  say it maps to x then the mapping of x next it can map
    * to only 14 values and so on. This means I am using
    * 15! mappings instead of 16!  this is still an effective
    * key of over 40 bits I have just eliminated the multipy
    * cycle mappings. And some lowand end value keys to make
    * it exactly 40 bits.
    */

   /*
    * input   prtb pointer to remainder table
    * output  pftb pointer to forward lookup table
    * output  pbtb pointer to reverse look up table
    */

   unsigned int    i, j;
   int            *pt, *pw;
   /* set up pbtb as work table first */
   for (i = 0; i < 16; i++)
      pbtb[i] = i;
   /* now build lookup table */
   pt = pftb;
   pw = pbtb;
   for (i = 16 - 1; i > 1; i--) {
      *prtb = *prtb % i;
      *pftb = *(++pw + *prtb);	/* forward table */
      *(pw + *prtb++) = *pw;
      pftb = pt + *pftb;
   }
   *pftb = *++pw;
   *(pt + *pftb) = 0;
   /* forward table done */
   /* checking for single cycle while makeing reverse table */
   for (i = pt[0], j = 1; j < 16; j++) {
      if (i == 0) {
	 printf(" table build FAILURE \n");
	 exit(1);
      }
      pbtb[pt[i]] = i;
      i = pt[i];
   }
   pbtb[pt[0]] = 0;
   if (i != 0) {
      printf(" table BUILD FAILURE\n");
      exit(1);
   }
}


void
Paul(b4 * a, un32 x)
{
   /* modified for 4 bit code instead of 16 as a check */
   /* *a is start of character array  x is number 8 bit characters */
   char           *i;
   b4             *ii;
   int             j;
   char           *cp;
   void           *vp;

   printf(" before Paul ");
   writehexline((char *) a, x);
   printf(" after  Paul ");

   i = vp = a;
   cp = vp;
   i = cp + x;
   /*
    This no tears routine added to defeat Paul Onion style
   of attack. So that a single cycle lookup table secure from
   a choosen plain text type of attack. Note XOR of a 16 bit
   number wiht a constant could be described as a 16 bit lookup
   table composed of only 2 cycle components. The single cycle
   lookup table will not ever decompose to an XOR type of transform
    */
   /*
    I am using a reverse cycle so that one would have to guess
   the entire table to get a constant vaule to first round.
   I am also doing the last round since maybe a reverse plain
   text attack is legal in to days circle of things. That is
   if the choosen enciphered text attack is allowed where
   enemy gives a phone encoded message and looks at the deoded
   results. As before this is for method where the file length
   is not changed. If more security needed or a large number
   of small files in use. USE the method with padding
   */
   /*
   for (j = ft[a[0].a0] ^ ft[ft[a[0].a0]]; --i != a; j = ft[j]) {
      *i ^= j;
   }
   */
   for (j = ft[a[0].a0] ^ ft[ft[a[0].a0]];
	--i != cp; j = ft[j]) {
      vp = i;
      ii = vp;
      ii[0].a1 ^= j;
      j = ft[j];
      ii[0].a0 ^= j;
   }
   vp = i;
   ii = vp;
   ii[0].a1 ^= j;
   writehexline((char *) a, x);

}
/*
 * I started at back of file and used ft instead of bt since bt does not
 * always exist and tried to save some memory. The j=ft[*a]^ft[ft[*a]] was
 * done so that the revese cycle would start at different places in cycle
 * less information for some types of attack.
 */



void
doEnce(b4 * a, un32 x)
{
   /* encrypts a file using 4 bit words */
   un32            i, j;
   if (x < 4) {
      printf(" this method for 4 or more characters only \n");
      exit(1);
   }
   Paul(a, x);
   for (i = 0; i < EFE; i++) {
      pb4(a, 0, 0, ft[(15 & (gb4(a, x - 1, 1) ^ gb4(a, 0, 0)) + gb4(a, 0, 1))]);

      for (j = 0; j < x - 1; j++) {
	 pb4(a, j, 1, ft[(15 & (gb4(a, j, 0) ^ gb4(a, j, 1)) + gb4(a, j + 1, 0))]);
	 pb4(a, j + 1, 0, ft[(15 & (gb4(a, j, 1) ^ gb4(a, j + 1, 0)) + gb4(a, j + 1, 1))]);
      }

      pb4(a, x - 1, 1, ft[(15 & (gb4(a, x - 1, 0) ^ gb4(a, x - 1, 1)) + gb4(a, 0, 0))]);

      pb4(a, x, 0, gb4(a, 0, 0));

      for (j = 0; j < x; j++) {
	 hold.i2.a0 = gb4(a, j, 0);
	 hold.i2.a1 = gb4(a, j, 1);
	 pb4(a, j, 0, hold.i1.a);

	 hold.i2.a0 = gb4(a, j, 1);
	 hold.i2.a1 = gb4(a, j + 1, 0);
	 pb4(a, j, 1, hold.i1.a);
      }
      printf("after pass %u", i + 1);
      writehexline((char *) a, x);
   }
   Paul(a, x);
   pb4(a, x, 0, 0);
   pb4(a, x, 1, 0);
}
void
doDece(b4 * a, un32 x)
{
   /* decrypts a file using 4 bit words */
   int             i, j;
   if (x < 2) {
      printf(" this method for 5 or more characters only \n");
      exit(1);
   }
   Paul(a, x);
   for (i = 0; i < EFE; i++) {
      pb4(a, -1, 1, gb4(a, x - 1, 1));
      for (j = x - 1; j >= 0; j--) {
	 hold.i2.a0 = gb4(a, j, 0);
	 hold.i2.a1 = gb4(a, j, 1);
	 pb4(a, j, 1, hold.i1.a);
	 hold.i2.a0 = gb4(a, j - 1, 1);
	 hold.i2.a1 = gb4(a, j, 0);
	 pb4(a, j, 0, hold.i1.a);
      }
      pb4(a, x - 1, 1, gb4(a, x - 1, 0) ^ (bt[gb4(a, x - 1, 1)] - gb4(a, 0, 0)));

      for (j = x - 1; j > 0; j--) {
	 pb4(a, j, 0, gb4(a, j - 1, 1) ^ (bt[gb4(a, j, 0)] - gb4(a, j, 1)));
	 pb4(a, j - 1, 1, gb4(a, j - 1, 0) ^ (bt[gb4(a, j - 1, 1)] - gb4(a, j, 0)));
      }

      /*
       * printf(" before a00 %u %u %u \n",gb4(a,x-1,1),
       * gb4(a,0,0),gb4(a,0,1));
       */
      /* if ( gb4(a,0,1) <= bt[gb4(a,0,0)])  */
      pb4(a, 0, 0, gb4(a, x - 1, 1) ^ (bt[gb4(a, 0, 0)] - gb4(a, 0, 1)));
      /*
       * else  pb4(a,0,0,     gb4(a,x-1,1) ^ (1+(15^(-bt[gb4(a,0,0)] +
       * gb4(a,0,1)))));
       */
   }
   Paul(a, x);
   pb4(a, x, 0, 0);
   pb4(a, x, 1, 0);
}

prtable(int *i)
{
   int             k;
   printf("\n");
   for (k = 16; k-- > 0;) {
      printf(" %x", *i++);
   }
   printf("\n");
}

prcycle(int *i)
{
   int             j, k;
   printf("\n");
   j = *i;
   for (k = 16; k-- > 0; j = i[j]) {
      printf(" %x", j);
   }
   printf("\n");
}
int 
readline(char *c)
{
   int             i;
   for (; (*c = getchar()) == '\n';);
   for (i = 1; (*++c = getchar()) != '\n'; i++) {
      if (i == 80)
	 break;
   }
   *c = 0;
   printf(" i= %u\n", i);
   return i;
}
void 
writehexline(char *c, int i)
{
   int             j;
   char            st[18];
   for (j = 0; j < i; j++) {
      sprintf(st, "%8.8x", *c++);
      printf("|%c%c", st[6], st[7]);	/* printf("%02.2x|",*c++); */
   }
   printf("|\n");
}
void 
writeline(char *c, int i)
{
   int             j;
   for (j = 0; j < i; j++)
      printf("%c|", *c++);
   printf("\n");
}

/* number of possible keys 0x0 to 0x130777757FF */
static long long key, ll1, ll2;
static long long big = 0x183BBBABFFll;
int 
main()
{
   int             i, j, k;
   char            s1[4], s[256], s2[4];
   printf("sizeof b4 %u \n", sizeof(b4));
   printf(" enter a 10 digit hex password for 40 bit key \n");
   scanf(" %llx%*[^\n]", &key);
   key &= 0xffffffffffll;
   /*
    for(key=0,j=2; j<16; j++)
   key=key*j+j-1; /* to make largest key value */

   printf(" key entered is %010llX \n", key);
   key += key < big ? 0x10000000000ll : 0;
   printf(" key used is   %011llX \n", key);
   printf(" build tables \n ");
   for (i = 15, j = 0; j < 16; i == 1 ? 1 : i--, j++) {
      rt[j] = key % i;
      key = key / i;
   }

   printf(" THE REMAINDER TABLE");
   prtable(rt);

   rem_tab4(rt, ft, bt);
   printf(" THE FORWARD TABLE");

   prcycle(ft);

   printf(" THE BACKWARD TABLE");
   prcycle(bt);
   printf("Enter a line to be encrypted with key \n");
   i = readline(s);

   /* test of Paul for(i=0;i<30;i++)s[i]=0;  */

   printf(" string is %u \"%s\"\n", i, s);
   writeline(s, i);
   writehexline(s, i);
   doEnce((b4 *) s, i);
   printf("  encrypted ");
   writehexline(s, i);
   printf(" string is %u \"%s\" \n", i, s);
   doDece((b4 *) s, i);
   printf("  decrypted ");
   writehexline(s, i);
   printf(" string is %u \"%s\" \n", i, s);

}
