/*
 *  SecuDE Release 4.3 (GMD)
 */
/********************************************************************
 * Copyright (C) 1994, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/
#ifdef MAC
#include <stdlib.h>
#endif /* MAC */

#include "psap.h"
#include "af.h"


/******* map 1:1 PE element <--> Octetstring structure ******/

/***************************************************************
 *
 * Procedure aux_PE2OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_PE2OctetString(
	PE	  pe
)

#else

OctetString *aux_PE2OctetString(
	pe
)
PE	  pe;

#endif

{

	OctetString * ostr;
	PS            ps = NULLPS;
	int	      in_line = 0;
	char	    * pbuff;
	char	    * proc = "aux_PE2OctetString";

	/* create ps and associate with string buffer: */
	if ((ps = ps_alloc(str_open)) == NULLPS) {
		aux_add_error(EMALLOC, "ps_alloc failed", CNULL, 0, proc);
		return((OctetString * )0);
	}
	if (str_setup(ps, NULLCP, 0, in_line) == NOTOK) {
		aux_add_error(EINVALID, "str_setup failed", ps_error(ps->ps_errno), char_n, proc);
		return((OctetString * )0);
	}

	/* force length form as specified by sec_asn1_length_encoding */
	ps_len_strategy = sec_asn1_length_encoding; /* see secure.h */

	/* pe --> ps: */
	if (pe2ps(ps, pe) == NOTOK) {
		aux_add_error(EINVALID, "pe2ps failed", ps_error(ps->ps_errno), char_n, proc);
		return((OctetString * )0);
	}

	/* ps --> ostr: */
	if ( (ostr = (OctetString * )malloc(sizeof(OctetString)))
	     == (OctetString * )0 ) {
		aux_add_error(EMALLOC, "ostr", CNULL, 0, proc);
		return((OctetString * )0);
	}
	ostr->noctets = ps->ps_bufsiz - ps->ps_cnt;
	if ( (ostr->octets = malloc(ostr->noctets)) == (char *)0 ) {
		aux_add_error(EMALLOC, "ostr->octets", CNULL, 0, proc);
		return((OctetString * )0);
	}
	ps->ps_ptr = ps->ps_base;     /*Reset PS-pointer*/
	ps->ps_cnt = ps->ps_bufsiz;   /*Reset PS-pointer*/
	if ( ps_read(ps, ostr->octets, ostr->noctets) == NOTOK ) {
		aux_add_error(EINVALID, "ps_read failed", ps_error(ps->ps_errno), char_n, proc);
		return((OctetString * )0);
	}

	/* free PS structure: */
	ps_free( ps );

	return( ostr );
}



/***************************************************************
 *
 * Procedure aux_OctetString2PE
 *
 ***************************************************************/
#ifdef __STDC__

PE aux_OctetString2PE(
	OctetString	 *ostr
)

#else

PE aux_OctetString2PE(
	ostr
)
OctetString	 *ostr;

#endif

{
	PE        pe = NULLPE;
	PS        ps = NULLPS;
	int	  in_line = 0;
	char	* pbuff;
	char	* proc = "aux_OctetString2PE";

	/* create ps and associate with string buffer: */
	if ((ps = ps_alloc(str_open)) == NULLPS) {
		aux_add_error(EMALLOC, "ps_alloc failed", CNULL, 0, proc);
		return(pe);
	}
	if (str_setup(ps, NULLCP, 0, in_line) == NOTOK) {
		aux_add_error(EINVALID, "str_setup failed", ps_error(ps->ps_errno), char_n, proc);
		return(pe);
	}

	/* Octetstring --> ps: */
	if ( ps_write(ps, ostr->octets, ostr->noctets) == NOTOK ) {
		aux_add_error(EINVALID, "ps_write failed", ps_error(ps->ps_errno), char_n, proc);
		return(pe);
	}
	ps->ps_ptr = ps->ps_base;     /*Reset PS-pointer*/
	ps->ps_cnt = ps->ps_bufsiz;   /*Reset PS-pointer*/

	/* ps --> pe: */
	if ( (pe = ps2pe(ps)) == NULLPE ) {
		aux_add_error(EINVALID, "ps2pe failed", ps_error(ps->ps_errno), char_n, proc);
		return(pe);
	}

	/* free PS structure: */
	ps_free( ps );

	return( pe );
}





