
## In order to build and install the system you MUST set appropriate 
## values for:
## 
##	PEM-root
##	LIBDIR
## 	CRYPTOLIBS
##	OSFLAGS
##	BINDIR
##      MANDIR
## 
## If you intend to run "make depend," which is not necessary since the
## necessary depend files are provided, you must also choose an
## appropriate "make depend" target.  Please see the depend target below
## for more information.


## Set the value of PEM-root to the rooted path to the pem directory
## within the distribution (the directory containing this file).
## 
PEM-root 	= /usr/local/src/pem-7.0/pem


## If necessary, set the value of LIBDIR to the rooted pathname of the
## directory containing the PEM libraries.  Normally, this would be:
## 
##	$(PEM-root)/lib
## 
LIBDIR		= $(PEM-root)/lib


## Set the value of CRYPTOLIBS to the location and name of the library
## containing the crypto-engine necessary to support the algorithms
## configured for use.
## 
## Normally, this is set to the location of rsaref.a.  If you place a
## copy of rsaref.a in the PEM library directory the default setting is
## correct.
## 
CRYPTOLIBS	= $(LIBDIR)/rsaref.a


## Set the value of OSFLAGS to include a -D with an item chosen from the 
## following list, all of which are mutually exclusive (e.g., -DSYS5).  
## If your OS is not included in this list, try something that is close.
## 
## 		BSD42	BSD43
## 		MACH		-- PEM assumes this when on NeXT machines
## 		NeXT		-- this is pre-defined on NeXT machines
## 		SUNOS3	SUNOS4
## 		SYS5
## 		TXENIX
## 
## The RSAREF package assumes it is being compiled with a compiler that
## prefers ANSI-style prototype declarations.  As a result, the include
## files that TIS/PEM has copied from RSAREF have a dependency on the
## setting of the macro PROTOTYPES.  If your compiler does not
## understand prototype declarations you will need to set PROTOTYPES to
## 0, as it is done in the SUN4FLAGS and SUN3FLAGS below.
## 
## Be sure to use the compiler macro definition syntax to specify the
## appropriate operating system value, i.e., -Dvalue.
## 
## We've had good luck with some of the following sets of options and
## others have reported good luck with others.  If one of the following
## macros is appropriate for your environment, it can be used instead of
## specifying the the options individually.  E.g., On a Sun SPARC, set
## OSFLAGS = $(SUN4FLAGS) instead of setting OSFLAGS = -DSUNOS4
## -DPROTOTYPES=0.
##
AIXFLAGS	= -DSYS5 -DPROTOTYPES=0
BSDI486FLAGS	= -DSYS5 -DBSDI
GCCFLAGS	= -traditional
HPUXFLAGS 	= -DSYS5 -DPROTOTYPES=0
NEXTFLAGS	= -bsd -fwritable-strings -traditional-cpp
SGIFLAGS	= -cckr -DPROTOTYPES=0
SOLARISFLAGS	= -DSYS5 -traditional -DPROTOTYPES=0
SUN3FLAGS	= -DSUNOS3 -DPROTOTYPES=0
SUN4FLAGS	= -DSUNOS4 -DPROTOTYPES=0
TXFLAGS		= -M2le -DTXENIX -DPROTOTYPES=0
ULTRIXMIPSFLAGS	= -G 4 -Olimit 1400

OSFLAGS		= $(SUN4FLAGS)


## Set the value of BINDIR to the name of the directory in which you
## want the TIS/PEM binaries to be installed.
## 
BINDIR		= /usr/local/bin


## Set the value of BINPERMS to the octal permission string you would 
## like placed on each of the installed executables.
##
BINPERMS	= 0755


## All values below this point, except the depend target included last,
## rarely need changes.  You may check them to be sure or you can trust
## us.

## If necessary, change the value of MANDIR.
## 
MANDIR		= /usr/local/man


## And the directories and extensions of the man pages.
##
DIR1		= manl
EXT1		= l
DIR5		= manl
EXT5		= l
DIR8		= manl
EXT8		= l


## And the permissions on the man pages.
##
MANPERMS	= 0644


## And the path to the catman command (nothing is ok) which is run after 
## the man pages are copied to update the whatis database (catman -w).
##
##CATMAN		= /usr/etc/catman
##CATMAN		= /etc/catman
CATMAN		=


## If necessary, set the value of INCDIR to the rooted pathname of the
## directory containing the PEM include files.  Normally this would be:
## 
##	$(PEM-root)/h
## 
INCDIR		= $(PEM-root)/h


## Compiler and compiler options (CC, OPTIONS)
##
## If you set CC to "gcc" you will also need to set LD to "gcc".
## 
## OPTIONS is provided as a convenient means of indicating those command
## line arguments that can be processed by both CC and LINT.
##
CC		= cc
OPTIONS		= -I$(INCDIR)


## Setting CFLAGS (OPTIONS, LOPTIONS, OSFLAGS, MOPTIONS)
## 
## Should not need to be tailored, unless you need to remove
## optimization (-O) and perhaps add debugging information (-g).
## 
## OPTIONS and OSFLAGS are described above.
##
## LOPTIONS may be set by a Makefile in a subdirectory that requires a
## special option during compilation and/or linting.
##
## MOPTIONS is intended to be used on the make command line as a
## convenient way to change compilation and linting options during
## development.
## 
CFLAGS		= -O $(OPTIONS) $(LOPTIONS) $(OSFLAGS) $(MOPTIONS)


## Loader, loader options and loader libraries (LD, LDOPTIONS, LDLIBS)
##
##	LDOPTIONS are inserted on the loader command line immediately
##	after the ld command and before object files.
##
##	LDLIBS are appended to the end of the loader command line
##	immediately after the object files.
##
##	On TXENIX, use the following macro definitions:
##		LD	  = ld
##		LDOPTIONS = -Ml -S 1024
##		LDLIBS	  = /lib/Llibc.a /lib/Lcrt0.o /lib/Lseg.o /lib/Llibx.a
##
##	On UTS, use the following macro definitions:
##		LD	  = cc
##		LDOPTIONS =
##		LDLIBS	  = /usr/lib/liba.a /usr/lib/libbsd.a \
##			    /usr/lib/libsocket.a
## 
## 	If you set CC above to "gcc", you will need to set LD to "gcc".
## 	In all other cases, the default should suffice.
## 
LD		= cc
LDOPTIONS	=
LDLIBS		=


## Setting LDFLAGS
## 
## Should not need to be tailored.
##
## LDOPTIONS is described above.
## 
## LLDOPTIONS may be set by a Makefile in a subdirectory that requires a
## special option during linking and/or loading.
## 
LDFLAGS 	= $(LDOPTIONS) $(LLDOPTIONS)


## If necessary, set the values of RANLIB and AR.
## 
RANLIB		= ranlib
AR		= ar


## LINT FLAGS (LFLAGS)
## 
##	a - assignments of long to non-long
##	b - report unreachable break statements
##	c - complain about questionable casts
##	h - heuristics to intuit bugs, improve style and reduce waste
##	i - produce .ln file for every .c file
##	n - do not check against standard library
##	u - use on subset of program
##	x - report variables referred to by extern but not used
##	C - create llib-lLIBRARY.ln, -CLIBRARY
##	l - use /usr/lib/lint/llib-lLIBRARY.ln, -lLIBRARY
##	o - name the output file, -o FILE
## SYSTEM V
##	reverse sense of a, b, h and x
##	c is defined as in i above
##	i is not available
##	C is not available, use -o or -c
##	c - produce .ln file for every .c file
##	p - check portability to other C dialects, including truncating all
##		non-external names to 8 characters and externals to 6
##	o - create llib-lLIBRARY.ln, -o LIBRARY
## 
## Should not need to be tailored.
##
## OPTIONS, LOPTIONS, OSFLAGS, and MOPTIONS are described above.
##
## LLOPTIONS may be set by a Makefile in a subdirectory that requires a
## special option during linting.
## 
LFLAGS		= -abhx $(LLOPTIONS) \
		  $(OPTIONS) $(LOPTIONS) $(OSFLAGS) $(MOPTIONS)

## Crypto lint libraries (CRYPTOLLIBS)
## 
## Should be tailored to specify the location and name of the lint
## library containing the lint information for the crypto-engine used to
## support the algorithms configured for use.
## 
## Normally, this is set to the location of llib-lrsaref.ln.  If you
## place a copy of llib-lrsaref.ln in the PEM library directory the
## default setting is correct.
##
CRYPTOLLIBS	= $(LIBDIR)/llib-lrsaref.ln


## MUST NOT BE TAILORED
##
## This specifies the correct order of linking the TIS/PEM libraries.
## 
LIBS	= \
	$(LIBDIR)/libparse.a \
	$(LIBDIR)/libpem.a \
	$(LIBDIR)/libcbio.a \
	$(LIBDIR)/libdata.a \
	$(LIBDIR)/libcert.a \
	$(LIBDIR)/libcrl.a \
	$(LIBDIR)/libcrypto.a \
	$(LIBDIR)/libdname.a \
	$(LIBDIR)/libasn1.a \
	$(LIBDIR)/libutil.a \
	$(CRYPTOLIBS) 

## Should not need to be tailored.
## 
LLIBS	= \
	$(LIBDIR)/llib-lasn1.ln \
	$(LIBDIR)/llib-lcbio.ln \
	$(LIBDIR)/llib-lcert.ln \
	$(LIBDIR)/llib-lcrl.ln \
	$(LIBDIR)/llib-lcrypto.ln \
	$(LIBDIR)/llib-ldata.ln \
	$(LIBDIR)/llib-ldname.ln \
	$(LIBDIR)/llib-lparse.ln \
	$(LIBDIR)/llib-lutil.ln \
	$(CRYPTOLLIBS)

## The following are the targets common to all directories.  None of
## them should need to be changed.

default:	real-default

clean:
		-rm -f *.o x$(TARGET) core \
			y.output y.tab.c y.tab.h lex.yy.c \
			$(LIBDIR)/$(TARGET) $(LIBDIR)/$(LTARGET)

distribution:	clean
		-rm -f *.bak *~ #*

lint:
		lint $(LFLAGS) $(SRC) $(LLIBS)

lint-lib:
		lint $(LLIB) $(LFLAGS) $(SRC)
		mv $(LTARGET) $(LIBDIR)/$(LTARGET)

print:
		lpr -p Makefile.pre Makefile.suf $(INC) $(SRC)


#  CHOOSING A 'MAKE DEPEND' TO GENERATE INCLUDE DEPENDENCIES
#
#  Three versions are supplied.  One for sites with cc -M (this is cc -Em
#  on some systems), one for sites without it but with reasonable cc -E
#  output and one for those that don't have either.  Comment out the ones
#  you do not want.
#
#  Note the #include syntax rules that apply to all:
#	1.  standard location files are indicated with <FILE.h>
#	2.  current directory files are indicated with "./FILE.h"
#	3.  INCDIR files are indicated with "FILE.h"
#	4.  all other files must have rooted paths: "/...FILE.h"

## This one is for sites without cc -M and cc -E
#
#  IF YOU USE THIS OPTION, SOME INAPPROPRIATE DEPENDENCIES WILL BE
#  GENERATED.  This is because the "grep" for "include" lines can not take
#  into account "include" lines that are dependent on certain options being
#  set or unset, ie conditionally included.  You will discover these as
#  "make" errors the first time you build the system after doing the "make
#  depend".  The "make" error will indicate that "make" "does not know how
#  to make FILE", where FILE is the inappropriate dependency.  The
#  appropriate source file should be checked to verify that FILE is
#  conditionally included and, if FILE is not intended to exist, the
#  Makefile.dep should be edited to remove the dependency.
#
#depend: $(SRC)
#	for i in $(SRC) ; do \
#		(echo $$i: $$i | sed -e 's,c:,o:,' >>makedep; \
#		/bin/grep '^#[ 	]*include[  ]*\"' /dev/null $$i | sed \
#			-e 's,c:[^"]*"\./\([^"]*\)".*,o: \1,' \
#			-e 's,c:[^"]*"/\([^"]*\)".*,o: /\1,' \
#			-e 's,c:[^"]*"\([^"]*\)".*,o: $$(INCDIR)/\1,' \
#			>>makedep); done
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
#	echo '$$r makedep' >>eddep
#	echo 'w' >>eddep
#	rm -f Makefile.dep.bak
#	cp Makefile.dep Makefile.dep.bak
#	rm -f Makefile.dep
#	cp Makefile.dep.bak Makefile.dep
#	ed - Makefile.dep < eddep
#	rm eddep makedep Makefile.dep.bak
#	echo '' >> Makefile.dep
#	echo '# THIS FILE IS AUTOMATICALLY GENERATED' >> Makefile.dep
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile.dep
#	echo '# see "make depend" for details' >> Makefile.dep

## This one is for sites without cc -M but with reasonable cc -E output
## Use this one for TXENIX machines
#
#  You MUST edit the SECOND "sed" command according to your preprocessor
#  output!  Some known possibilities are to change "#line" to be either
#  "#" or "# line".
#
#depend: $(SRC)
#	for i in $(SRC) ; do \
#		(echo $$i: $$i | sed -e 's,c:,o:,' >> makedep; \
#		cc -E $(CFLAGS) $$i | \
#		grep '^#line' | sort -u +2 -3 | \
#		sed -e 's/#line [0-9]* \(.*\)/'$$i': #include \1/p' | \
#		sed -e 's,c:[^"]*"\([^"]*\)".*,o: \1,' | \
#	        egrep '($(INCDIR))|(.*\.c)|(\.\/.*\.h)' | \
#		sed -w 's,$(INCDIR),$$(INCDIR),' \
#		>>makedep); done
#	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
#	echo '$$r makedep' >>eddep
#	echo 'w' >>eddep
#	rm -f Makefile.dep.bak
#	cp Makefile.dep Makefile.dep.bak
#	rm -f Makefile.dep
#	cp Makefile.dep.bak Makefile.dep
#	ed - Makefile.dep < eddep
#	rm eddep makedep Makefile.dep.bak
#	echo '' >> Makefile.dep
#	echo '# THIS FILE IS AUTOMATICALLY GENERATED' >> Makefile.dep
#	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile.dep
#	echo '# see "make depend" for details' >> Makefile.dep

## This one is for sites with cc -M
#
depend: $(SRC)
	( for i in $(SRC) ; do \
		${CC} -M $(CFLAGS) $$i ; done ) | \
	egrep '($(INCDIR))|(.*\.c)|(\.\/.*\.h)' |\
	sed -e 's,$(INCDIR),$$(INCDIR),' | \
	awk ' { if ($$1 != prev) { print rec; rec = $$0; prev = $$1; } \
		else { if (length(rec $$2) > 78) { print rec; rec = $$0; } \
		       else rec = rec " " $$2 } } \
	      END { print rec } ' > makedep
	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
	echo '$$r makedep' >>eddep
	echo 'w' >>eddep
	rm -f Makefile.dep.bak
	cp Makefile.dep Makefile.dep.bak
	rm -f Makefile.dep
	cp Makefile.dep.bak Makefile.dep
	ed - Makefile.dep < eddep
	rm eddep makedep Makefile.dep.bak
	echo '' >> Makefile.dep
	echo '# THIS FILE IS AUTOMATICALLY GENERATED' >> Makefile.dep
	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile.dep
	echo '# see "make depend" for details' >> Makefile.dep
