/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"


main (argc, argv)
int argc;
char **argv;
{
    int r = NOTOK;
    char **localopts = NULLVP;
    char **ifileopt = NULLVP;
    char **icfileopt = NULLVP;
    char **aliasfopt = NULLVP;
    char **newuser = NULLVP;
    char **privkeyopt = NULLVP;
    char **privaccessopt = NULLVP;
    char **dnpair = NULLVP;
    char *dn = NULLCP;
    char *aliasline;
    char *dnpart;
    char *bbfilename = NULLCP;
    struct bbuf *cert = NULLBB;
    struct bbuf *pecert = NULLBB;
    char *certstring = NULLCP;
    struct bbuf *key = NULLBB;
    struct bbuf *pekey = NULLBB;
    int i;
    long size = 0L;
    FILE *aliasfile = (FILE *)0;
    FILE *bbfile = (FILE *)0;
    FILE *keyfile = (FILE *)0;

    if (pem_init(argc, argv, &localopts) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    /* check args, display help */

    if (argc < 2 || !strcasecmp (argv[1], "help")) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr,
       "Usage: %s %s\n       %s\n       %s\nor\n       %s %s\n       %s\n",
		       myname,
		       "file <filename>",
		       "[ private-key-access <access> private-key <data> ]",
		       "[ alias-file <filename> ]",
		       myname,
		       "cfile <filename>",
		       "[ alias-file <filename> ]");
	exit(1);
    }

    /* see what options we were given */

    ifileopt = tag_user(localopts, "file");
    icfileopt = tag_user(localopts, "cfile");
    aliasfopt = tag_user(localopts, "alias-file");
    privkeyopt = tag_user(localopts, "private-key");
    privaccessopt = tag_user(localopts, "private-key-access");
    
    if ((ifileopt == NULLVP && icfileopt == NULLVP) ||
	(ifileopt != NULLVP && icfileopt != NULLVP)) {
	fprintf (stderr,
		 "Either file or cfile is required.\n");
	goto cleanup;
    }

    if ((privkeyopt != NULLVP && privaccessopt == NULLVP) ||
	(privkeyopt == NULLVP && privaccessopt != NULLVP)) {
	fprintf (stderr,"%s%s\n",
		 "Both private-key and private-key-access must be ",
		 "present or absent.");
	goto cleanup;
    }

    if (privaccessopt != NULLVP && strcasecmp (*(privaccessopt+1), "file")
	!= 0) {
	fprintf (stderr,"private-key-access %s not understood.\n",
		 *(privaccessopt+1));
        goto cleanup;
    }

    if (icfileopt != NULLVP && privkeyopt != NULLVP) {
        fprintf (stderr,"Private keys are not stored in cfiles.\n");
        goto cleanup;
    }

    /* open the file with the cert */

    if (ifileopt != NULLVP)
	bbfilename = *(ifileopt+1);
    else 
	bbfilename = *(icfileopt+1);

    if ((bbfile = fopen (bbfilename, "r")) == (FILE *)0) {
        fprintf (stderr,"Unable to open %s.\n", bbfilename);
	goto cleanup;
    }

    /* skip past other cfile bbufs */

    if (icfileopt != NULLVP) 
	for (i = 0; i < 5; i++)
	    if (fread(&size, sizeof(size), 1, bbfile) != 1) {
		fprintf(stderr, "Error reading cfile.\n");
		goto cleanup;
	    }
	    else {
		BSWAP(size);
		if (fseek(bbfile, size, 1) != 0) {
		    fprintf(stderr, "Cfile is corrupt.\n");
		    goto cleanup;
		}
	    }
    
    /* read the ASN.1 encoded cert */

    if (fread(&size, sizeof(size), 1, bbfile) != 1) { 	
	fprintf(stderr, "Error reading length of certificate.\n"); 	 
	goto cleanup;   
    }
    BSWAP(size);
    if (size == 0) {
	fprintf(stderr, "Certificate length is zero.\n"); 	 
	goto cleanup;   
    }
    if (size > 10000) {
	fprintf(stderr, "Certificate size indicates corruption.\n"); 	 
	goto cleanup;   
    }
    
    cert = alloc_bbuf();
    cert->length = size;
    cert->data = alloc_uchar(cert->length);
    if (fread(cert->data, size, 1, bbfile) != 1) {
        fprintf(stderr, "Error reading certificate.\n");
        goto cleanup;
    }

    /* printably encode the cert and make a string copy */

    bencode (cert, &pecert);
    certstring = alloc_char(pecert->length + 1);
    strncpy(certstring, pecert->data, pecert->length);

    /* explode the cert to produce the new user record */

    if ((newuser = explode_cert(certstring)) == NULLVP) {
        fprintf(stderr, "Unable to explode certificate into components.\n");
        goto cleanup;
    }

    /* if we're processing an exported reg & have key & key save info... */

    if (ifileopt != NULLVP) {

	i = fread(&size, sizeof(size), 1, bbfile);

	if (privkeyopt == NULLVP) {
	    if (i == 1) {
		fprintf(stderr, 
    "Ignoring private key for lack of private-key access and private-key.\n");
	    }
	}
	else {
	    if (i != 1) 
		fprintf(stderr, "No private key to save; continuing.\n");
	    else {
		
		BSWAP(size);
		key = alloc_bbuf();
		key->length = size;
		key->data = alloc_uchar(key->length);
		if (fread(key->data, key->length, 1, bbfile) != 1) {
		    fprintf(stderr, "Error reading private key.\n");
		    goto cleanup;
		}
		newuser = add2av(newuser, add2cp(NULLCP,"private-key-access"));
		newuser = add2av(newuser, add2cp(NULLCP,"file"));
		newuser = add2av(newuser, add2cp(NULLCP,"private-key"));
		newuser = add2av(newuser, add2cp(NULLCP,*(privkeyopt+1)));
		if (sav_key(newuser, NULLBB, key) != OK) {
		    fprintf(stderr, "Unable to save private key.\n");
		    goto cleanup;
		}
	    }
	}
    }
	
     fclose(bbfile);

    /* if an alias file was provided, search the alias file for aliases */

    if (aliasfopt != NULLVP) {
	if ((aliasfile = fopen (*(aliasfopt+1), "r")) == (FILE *)0) {
	    fprintf(stderr, "Unable to open alias file %s.\n", *(aliasfopt+1));
	    goto cleanup;
	}
	dnpair = tag_user (newuser, "subject-name");
	if (dnpair != NULLVP) 
	{
	    dn = *(dnpair+1);
	    while ((aliasline = getline(aliasfile)) != NULLCP) {
		dnpart = INDEX(aliasline, '/');
		if (!strcmp(dn, dnpart)) {
		    *dnpart = NULLC;
		    newuser = add2av(newuser, add2cp(NULLCP, "alias"));
		    newuser = add2av(newuser, add2cp(NULLCP, aliasline));
		}
		FREE(aliasline);
	    }
	}
	fclose(aliasfile);
    }

    /* update the database */
    
    if (update_indexfile(NULLVP, newuser) != OK) {
        fprintf(stderr, "Unable to update the database.\n");
        goto cleanup;
    }

    r = OK;

 cleanup:
    
    exit(r);
}
