/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>		/* we need stderr */
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "user_list.h"
#include "util.h"

static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static int user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd, bb));
}

static int error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd, bb));
}

struct user_list *validate_user();

main(argc, argv)
int argc;
char **argv;
{
    char             **av = NULLVP,
                     **me = NULLVP,
                     **user = NULLVP;
    char              *puser = NULLCP;
    struct cbstruct    iocbs;
    struct user_list  *root = NULLUL,
                      *valid_path = NULLUL;

    if (argc < 3 || !strcmp(argv[1], "help")) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s %s\n", *argv, "alias <alias>");
	exit(1);
    }

    if (pem_init(argc, argv, &av) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", *argv);
	exit(1);
    }

    /* set up callbacks in case we need them */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.out_errs = error_out;
    iocbs.out_user = error_out;

    /* process arguments */

    if (tag_user(av, "alias") == NULLVP) {
	(void) fprintf(stderr, "%s: missing alias\n", *argv);
	exit(1);
    }

    /* get my user records so I know where the root is */

 {
    char  **myalias = NULLVP;

    if ((myalias = tag_user(user_tailor, "my-alias")) == NULLVP) {
	fprintf(stderr, "%s: missing my-alias.\n", *argv);
	exit(1);
    }

    rewind_indexfile();
    while ((me = get_tv_user("alias", *(myalias+1))) != NULLVP) {
	struct user_list *up;

	up = alloc_ul();
	up->user = me;
	up->next = root;
	root = up;
    }
    if (root == NULLUL) {
	(void) fprintf(stderr, "%s: missing user for tag my-alias value %s\n",
		       *argv, *(myalias+1));
	exit(1);
    }
 }

    /* get the user record to validate */

    rewind_indexfile();
    if ((user = get_tvt_user(av)) == NULLVP) {
	(void) fprintf(stderr, "%s: no such user as:\n\n", *argv);
	(void) pem_disp(av, &iocbs);
	exit(1);
    }

    /* do the validation */

    valid_path = validate_user(user, root);

    /* okay, switch to stdout and output the results */

    iocbs.out_user = user_out;

    cp2cb(iocbs.out_user, "For ");
    puser = pretty_user(user);
    cp2cb(iocbs.out_user, puser);
    cp2cb(iocbs.out_user, "\n");

    if (root->next != NULLUL) {
	cp2cb(iocbs.out_user, "\nWith roots:\n");
	while (root != NULLUL) {
	    cp2cb(iocbs.out_user, "\t");
	    puser = pretty_user(root->user);
	    cp2cb(iocbs.out_user, puser);
	    cp2cb(iocbs.out_user, "\n");
	    root = root->next;
	}
    }
    else {
	cp2cb(iocbs.out_user, "\nWith root:");
	puser = pretty_user(root->user);
	cp2cb(iocbs.out_user, puser);
	cp2cb(iocbs.out_user, "\n");
    }

    cp2cb(iocbs.out_user, "\nFound path:\n");
    if (valid_path == NULLUL)
	cp2cb(iocbs.out_user, "\tunable to validate \n");
    else {
	while (valid_path != NULLUL) {
	    cp2cb(iocbs.out_user, "\t");
	    puser = pretty_user(valid_path->user);
	    cp2cb(iocbs.out_user, puser);
	    cp2cb(iocbs.out_user, "\n");
	    valid_path = valid_path->next;
	}
    }

    exit(0);
}
