/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef _OID_
#define _OID_

/* OBJECT IDENTIFIERS */

#define NELEM 20

typedef struct OIDentifier {
    int oid_nelem;		 /* number of sub-identifiers */
    unsigned long *oid_elements; /* the (ordered) list of sub-identifiers */
}	OIDentifier, *OID;

#define	NULLOID	((OID) 0)

#define FREE_OID(x)     	if ((x) != NULLOID) { \
				    (void) oid_free(x); \
				    (x) = NULLOID; \
				} \
				else

int	oid_cmp ();
OID	oid_cpy ();
int	oid_free ();
char   *sprintoid ();
OID	str2oid ();

OID	prim2oid ();

#include "bbuf.h"
struct bbuf *oid2prim ();

#endif	/* _OID_ */
