/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*
 * Read the standard input and output all lines on the standard output
 * except the first 'N' lines, where 'N' is a required parameter.
 *
 * BUGS:
 *   Will not properly count lines that are longer than BUFSIZ.
 */

#include <stdio.h>

main(argc, argv)
int argc;
char **argv;
{
    char buf[BUFSIZ];
    int lines = 0;

    if (argc != 2) {
    usage:;
	fprintf(stderr, "Usage: %s -N\n", *argv);
	exit(1);
    }

    switch (**++argv) {
    case '-':
    {
	char *cp = *argv;

	if ((lines = atoi(++cp)) < 0)
	    goto usage;

	break;
    }

    default:
	goto usage;
    }

    while (lines-- && fgets(buf, sizeof buf, stdin) != (char *)0)
	;

    if (ferror(stdin) || (feof(stdin) && lines >= 0))
	exit(1);

    while (fgets(buf, sizeof buf, stdin) != (char *)0)
	fputs(buf, stdout);

    fflush(stdout);

    exit(0);
}
