/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"


static int headerfd = 0;	/* standard input by default */


static struct bbuf *header_in()
{
    return(cbfdread(headerfd));
}

static error_out(bbuf)
struct bbuf *bbuf;
{
    (void) fprintf(stderr, "%s", bbuf -> data);
    (void) fflush(stderr);

    return(OK);
}


main(argc, argv)
int	argc;
char	**argv;
{
    int r = NOTOK;
    struct cbstruct iocbs;
    char **localopts = NULLVP;
    char **headername = NULLVP;
    FILE *hdrs = (FILE *)0;
    
    /*  Initialize TIS/PEM  */

    if (pem_init(argc, argv, &localopts) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    /* Check args */

    if (argc == 2 && !strcasecmp(argv[1], "help")) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s [header-in <filename>]\n", myname);
        goto cleanup;
    }

    if ((headername = tag_user(localopts, "header-in")) != NULLVP) {
	if ((hdrs = fopen(*(headername+1), "r")) == (FILE *)0) {
	    (void) fprintf(stderr, "%s: unable to open header-in file %s.\n",
			   myname, *(headername+1));
	    goto cleanup;
	}
	headerfd = fileno(hdrs);
    }

    /* set up for call */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.in_hdrs = header_in;
    iocbs.out_errs = error_out;

    /* doit */

    if ((r = pem_savkeydata(&iocbs)) != OK) 
	(void) fprintf(stderr, "%s: unable to save key, cert(s), or crl(s).\n",
		       myname);

 cleanup:

    if (hdrs != (FILE *)0)
	fclose(hdrs);
    exit(r);
}

