/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "oid.h"
#include "util.h"

decode_oid(eoid, doid, rlength)
struct bbuf *eoid;
OID *doid;
int *rlength;
{
    struct bbuf *bb = NULLBB;
    int length;
    int llen;
    int r = OK;
	
    if (eoid == NULLBB) {
	return(NOTOK);
    }
    if (doid == (OID *)0) {
	return(NOTOK);
    }
    FREE_OID(*doid);

    if (rlength == (int *)0) {
	return(NOTOK);
    }

    if (eoid->length < 2) {
	return(ASN1_ERR01);
    }
    if (eoid->data[0] != (CLASS_UNIV|FORM_PRIM|PRIM_OID)) {
	return(ASN1_ERR02);
    }

    r = decode_len(&(eoid->data[1]), eoid->length-1, &length, &llen);
    if (r != OK) return(r);
    *rlength = 1 + llen + length;

    if ((bb = alloc_bbuf()) == NULLBB) {
	return(NOTOK);
    }

    bb->data = &(eoid->data[1+llen]);
    bb->length = length;

    if ((*doid = oid_cpy(prim2oid(bb))) == NULLOID) {
	r = ASN1_ERR22;
	goto cleanup;
    }

 cleanup:

    if (bb != NULLBB) {
	bb->data = (unsigned char *)0;
	(void) free_bbuf(bb);
    }

    return(r);
}
