/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_int(dint, eint)
int dint;
struct bbuf **eint;
{
    struct bbuf *bb;
    struct bbuf *lenbb = NULLBB;
    int r;
	
    if (eint == (struct bbuf **)0) {
	return(NOTOK);
    }

    if (*eint != (struct bbuf *)0) {
	(void) free_bbuf(*eint);
	*eint = (struct bbuf *)0;
    }

    if ((bb = int2prim(dint)) == NULLBB)
	return(ASN1_ERR23);

    if ((r = encode_len(bb->length, &lenbb)) != OK) {
	(void) free_bbuf(bb);
	return(r);
    }

    *eint = alloc_bbuf();

    (*eint)->data = alloc_uchar(1+lenbb->length+bb->length);
    (*eint)->length = 1 + lenbb->length + bb->length;

    (*eint)->data[0] = (CLASS_UNIV | FORM_PRIM | PRIM_INT);
    BCOPY(lenbb->data, &((*eint)->data[1]), lenbb->length);
    BCOPY(bb->data, &((*eint)->data[1+lenbb->length]), bb->length);

    (void) free_bbuf(bb);
    (void) free_bbuf(lenbb);

    return(OK);
}
