/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cert.h"
#include "crypto.h"
#include "dname.h"
#include "new.h"
#include "util.h"

sign_cert(cert, ekey)
struct bbuf **cert;
struct bbuf *ekey;
{
    struct algid *ik_aid = NULL_ALGID, *mic_aid = NULL_ALGID;
    struct bbuf *sig = NULLBB, *etbs = NULLBB, *mic = NULLBB,
		*emic = NULLBB, *dn = NULLBB;
    struct tobesigned *tbs = NULL_TOBESIGNED;
    int ret = NOTOK, slen;
    char **tv;
    struct algent *ae = NULL_ALGENT;
    struct algid *sig_aid = NULL_ALGID;

    if (cert == (struct bbuf **)0 || *cert == NULLBB) {
	return(NOTOK);
    }
    if (ekey == NULLBB) {
	return(NOTOK);
    }

    if ((tv = tag_user(user_tailor, "sig-alg")) == NULLVP)
	goto cleanup;
    if ((ae = getalgstr(algorithms, *(tv+1), SIG)) == NULL_ALGENT)
	goto cleanup;
    if ((mic_aid = alloc_algid()) == NULL_ALGID) 
	goto cleanup;
    mic_aid->alg = ae->code & HASH_MASK;
    if ((sig_aid = alloc_algid()) == NULL_ALGID)
	goto cleanup;
    sig_aid->alg = ae->code;

    if (algid_key(&ekey, &ik_aid, READ) != OK) {
	goto cleanup;
    }
    if (sig_alg_cert(cert, &sig_aid, INNER|OUTER, WRITE) != OK) {
        goto cleanup;
    }

    if (tobesigned_cert(cert, &tbs, READ) != OK) {
	goto cleanup;
    }

    /* Make sure distinguished names are DER */
    if (tbs->issuer != NULLBB && (dn = der_dn(tbs->issuer)) == NULLBB) {
	goto cleanup;
    }
    FREE_BBUF(tbs->issuer);
    tbs->issuer = dn, dn = NULLBB;

    if (tbs->subject != NULLBB && (dn = der_dn(tbs->subject)) == NULLBB) {
	goto cleanup;
    }
    FREE_BBUF(tbs->subject);
    tbs->subject = dn, dn = NULLBB;

    if (encode_ctbs(tbs, &etbs) != OK) {
	goto cleanup;
    }
    if (gen_mic(mic_aid->alg, NULLBB, etbs, &mic) != OK) {
	goto cleanup;
    }
    if (encode_mic(mic, mic_aid, &emic) != OK) {
	goto cleanup;
    }
    if (set_key(ekey) != OK) {
	goto cleanup;
    }
    if (sign(emic, &sig) != OK) {
	goto cleanup;
    }
    slen = sig->length;
    if (sig_cert(cert, &(sig->data), &slen, WRITE) != OK) {
	sig->length = (short)slen;
	goto cleanup;
    }
    sig->length = (short)slen;

    ret = OK;

 cleanup:

    FREE_TOBESIGNED(tbs);
    FREE_BBUF(sig);
    FREE_BBUF(etbs);
    FREE_BBUF(mic);
    FREE_BBUF(emic);
    FREE_ALGID(ik_aid);
    FREE_ALGID(mic_aid);
    FREE_ALGID(sig_aid);

    return(ret);
}

/*****************************************************************************/
