/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

struct crl *dup_crl(crl)
struct crl *crl;
{
    struct crl *p = NULL_CRL;

    if (crl != NULL_CRL) {
	if (alloc_crl(&p) != OK)
	    return(NULL_CRL);

	p -> status = crl -> status;

        if (crl->tobesigned != NULL_CRLTOBESIGNED)
	    p->tobesigned = dup_crltobesigned(crl->tobesigned);

        if (crl->sig_alg != NULL_ALGID)
	    p->sig_alg = dup_algid(crl->sig_alg);

        if (crl->sig != NULLBB)
	    p->sig = dup_bbuf(crl->sig);
    }

    return(p);
}

struct crltobesigned *dup_crltobesigned(s)
struct crltobesigned *s;
{
    struct crltobesigned *d;

    if (s == NULL_CRLTOBESIGNED)
	return(NULL_CRLTOBESIGNED);

    d = alloc_crltobesigned();

    if (s->sig_alg != (struct algid *)0)
	d->sig_alg = dup_algid(s->sig_alg);

    if (s->issuer != NULLBB)
	d->issuer = dup_bbuf(s->issuer); 

    if (s->rcl != NULL_RCL_ENTRY)
	d->rcl = dup_rcl(s->rcl);

    d->lastupdate = s->lastupdate;

    d->nextupdate = s->nextupdate;

    return(d);
}

struct rcl_entry *dup_rcl(s)
struct rcl_entry *s;
{
    struct rcl_entry *d, *tmp, *ptr;

    if (s == NULL_RCL_ENTRY)
	return(NULL_RCL_ENTRY);

    if ((d = dup_rcl_entry(s)) == NULL_RCL_ENTRY)
	return(d);

    ptr = d;
    for (tmp = s->next; tmp != NULL_RCL_ENTRY; tmp = tmp->next) {
	ptr->next = dup_rcl_entry(tmp);
	ptr->next->prev = ptr;
	ptr = ptr->next;
    }

    return(d);
}

struct rcl_entry *dup_rcl_entry(s)
struct rcl_entry *s;
{
    struct rcl_entry *d;

    if (s == NULL_RCL_ENTRY)
	return(NULL_RCL_ENTRY);

    d = alloc_rcl_entry();

    if (s->serial != NULLBB)
        d->serial = dup_bbuf(s->serial);

    d->date = s->date;

    return(d);
}
