/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * encode_rtbs.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

encode_rtbs(dtbs,etbs)
struct crltobesigned *dtbs;
struct bbuf **etbs;
{
    int r = NOTOK;
    struct bbuf *bb= NULLBB, *bb2= NULLBB, *bb3= NULLBB;

    /* CHECK OUTPUT PARAMTERS */
    if (etbs == (struct bbuf **)0) {
	r = NOTOK;
        goto cleanup;
    }
    FREE_BBUF(*etbs);

    /* ENCODE MISSING TOBESIGNED AS A NULL */
    if (dtbs == NULL_CRLTOBESIGNED) {
	r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, etbs);
        goto cleanup;
    }

    /* ENCODE THE SIGNATURE ALGORITHM IDENTIFIER */
    if ((r = encode_algid(dtbs->sig_alg, &bb2)) != OK)
	goto cleanup;

    /* ENCODE THE ISSUER DNAME & APPEND */
    if (dtbs->issuer != NULLBB) {
        if ((bb = dup_bbuf(dtbs->issuer)) == NULLBB) {
            r = NOTOK;
            goto cleanup;
        }
    }
    else {
        if ((r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
            goto cleanup;
    }
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE UTC LASTUPDATE & APPEND */
    if ((r = encode_utct(dtbs->lastupdate, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE UTC NEXTUPDATE & APPEND */
    if ((r = encode_utct(dtbs->nextupdate, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE REVOKED CERTIFICATE LIST & APPEND */
    if ((r = encode_rcl(dtbs->rcl, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
	goto cleanup;
    *etbs = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK; 

 cleanup:

    if (r != OK) 
        FREE_BBUF(*etbs);

    FREE_BBUF(bb2);

    return(r);
}

/*****************************************************************************/
