/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crl.h"
#include "util.h"

tobesigned_crl(crl, tobesigned, mode)
struct bbuf **crl;
struct crltobesigned **tobesigned;
int mode;
{
    struct crl  *dcrl= NULL_CRL;
    int		ret= NOTOK;

    /* we need code to do a "dump" of crl here */

    if (crl == (struct bbuf **)0 || *crl == NULLBB) 
	goto cleanup;

    if (tobesigned == (struct crltobesigned **)0) 
	goto cleanup;

    if (decode_crl(*crl, &dcrl) != OK) 
	goto cleanup;

    switch (mode) {
    case READ:
	FREE_CRLTOBESIGNED(*tobesigned);
	if (dcrl->tobesigned != NULL_CRLTOBESIGNED
	    && (*tobesigned = dup_crltobesigned(dcrl->tobesigned))
	    == NULL_CRLTOBESIGNED)
	    goto cleanup;
	ret = OK;

	break;

    case WRITE:
	FREE_CRLTOBESIGNED(dcrl->tobesigned);

	if (*tobesigned != NULL_CRLTOBESIGNED 
	    && ((dcrl->tobesigned = dup_crltobesigned(*tobesigned))
		== NULL_CRLTOBESIGNED))
	    goto cleanup;

        ret = encode_crl(dcrl, crl);
	break;

    default:

	goto cleanup;
    }

 cleanup:

    FREE_CRL(dcrl);
    return(ret);
}
