/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "util.h"

int encipher(plain, cipher)
struct bbuf *plain;
struct bbuf **cipher;
{
    int r;
    struct algent *ae = NULL_ALGENT;
    struct ccbent *ce = NULL_CCBENT;

    if (plain == NULLBB || cipher == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*cipher);

    if (curdata == NULLBB) 
	return(NOTOK);

    /* GET ALGORITHM ENTRY FROM TABLE */
    if ((ae = getalgcode(algorithms, curalg, IK|PE)) == NULL_ALGENT) 
        return(NOTOK);

    /* GET CALLBACK TABLE ENTRY */
    if ((ce = getccbcode(callbacks, ae->code)) == NULL_CCBENT) 
        return(NOTOK);

    if (ce->encipher_X == NULL_FUNC) 
        return(NOTOK);

    /* PERFORM ENCRYPTION */
    r = (*(ce->encipher_X))(plain, cipher);

    return(r);
}

/*****************************************************************************/
