/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * initprng.c
 ****************************************************************************/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "new.h"
#include "util.h"

/****************************************************************************
 * seedbysig()
 ****************************************************************************/

struct bbuf *seedbysig(user) 
char **user;
{
    static int initcount = 0;	/* ensure that seed is different if re-init */

    struct algid *aid = NULL_ALGID;
    struct bbuf *newseed  = NULLBB;
    struct bbuf *sigfood  = NULLBB;
    struct bbuf *dfoodmic = NULLBB;
    struct bbuf *efoodmic = NULLBB;
    struct bbuf *privkey  = NULLBB;
    long sigmisc [8];
    char sighost [20];
    int keystatus;

    if (user == NULLVP)
	goto cleanup;

    /* Generate the seed food.  The combination of seed food should be 
     * unique for the current signature key.
     */

    sigmisc[0] = TIME();
    sigmisc[1] = getpid();
    sigmisc[2] = getppid();
    sigmisc[3] = getuid();
    sigmisc[4] = geteuid();
    sigmisc[5] = getgid();
    sigmisc[6] = getegid();
    sigmisc[7] = initcount++;
    gethostname (sighost, sizeof(sighost));
 
    /* Create the bbuf to be signed */

    sigfood = alloc_bbuf();
    sigfood -> length = sizeof(sigmisc) + sizeof(sighost); 
    sigfood -> data = alloc_uchar(sigfood -> length);

    /*  Place the seed food into the bbuf to be signed */

    BCOPY(sigmisc, sigfood -> data, sizeof(sigmisc));
    BCOPY(sighost, sigfood -> data + sizeof(sigmisc), sizeof(sighost));

    /*  Hash the food first */

    /* if (gen_mic(hash_alg, NULL_KEY, sigfood, &dfoodmic) != OK) */

    if (gen_md5(NULL_KEY, sigfood, &dfoodmic) != OK)
 	goto cleanup;

    /*  Encode the hashed food */

    aid = alloc_algid();
    /* aid -> alg = hash_alg; */
    aid->alg = MD5;

    if (encode_mic(dfoodmic, aid, &efoodmic) != OK)
	goto cleanup;

    /* Make sure we have access to the private key */

    if (getalgcode(algorithms, curalg, SIG) == NULL_ALGENT) {

	if ((keystatus = get_key(user, NULLCP, &privkey)) != OK)
	    goto cleanup;

	if (!strcasecmp(*(tag_user(user, "private-key-access")+1), "file") &&
	    privkey != NULLBB)
	    if (set_key(privkey) != OK) goto cleanup;
    }

    /* Encrypt the MIC to produce the signature */

    if (sign(efoodmic, &newseed) != OK)
        goto cleanup;

 cleanup:
  
    FREE_ALGID(aid);
    FREE_BBUF(sigfood);
    FREE_BBUF(dfoodmic);
    FREE_BBUF(efoodmic);
    FREE_BBUF(privkey);
 
    return(newseed);
}


/****************************************************************************
 * initprng()
 ****************************************************************************/

int initprng(user)
char **user;
{
    FREE_BBUF(seedbb);

    if (user != NULLVP)
	seedbb = seedbysig(user);
    else
	seedbb = seedbyscript();

    return (seedbb != NULLBB ? OK : NOTOK);
}

/***************************************************************************/
