/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "cert.h"
#include "crl.h"
#include "key.h"
#include "new.h"
#include "util.h"

pem_disp(user, iocbs)
char **user;
struct cbstruct *iocbs;
{
    int ret = NOTOK;
    char **tag = NULLVP;
    char **print = NULLVP;
    char **av = NULLVP;
    char *cp = NULLCP;
    struct bbuf dummybb;
    struct bbuf *bb = NULLBB;

    if (user == NULLVP || iocbs == NULL_IOCBS || iocbs->out_user == NULL_OUTCB)
	goto cleanup;

    for (tag = user; *tag != NULLCP; tag+= 2) {
	cp = add2cp(cp, *tag);
	cp = add2cp(cp, ": ");
	cp = add2cp(cp, *(tag+1));
	cp = add2cp(cp, "\n");
	cp2cb(iocbs->out_user, cp);
	FREE(cp);

	if (!strcasecmp (*tag, "public-key")) {

	    dummybb.data = (unsigned char *) *(tag+1);
	    dummybb.length = strlen(*(tag+1));
	    if (bdecode(&dummybb, &bb) != OK)
		cp2cb (iocbs->out_user, "    Unable to decode.\n");
	    else {
		if (disp_key(bb, &print) != OK)
		    cp2cb (iocbs->out_user, "    Unable to print.\n");
		else {
		    prefixav(print, "    ");
		    for (av = print; av != NULLVP && *av != NULLCP; av++) {
			cp2cb (iocbs->out_user, *av);
			cp2cb (iocbs->out_user, "\n");
		    }
		    FREE_AV(print);
		}
		FREE_BBUF(bb);
	    }
	}
	
	else if (!strcasecmp (*tag, "certificate")) {
	    
	    dummybb.data = (unsigned char *) *(tag+1);
	    dummybb.length = strlen(*(tag+1));
	    if (bdecode(&dummybb, &bb) != OK)
		cp2cb (iocbs->out_user, "    Unable to decode.\n");
	    else {
		if (disp_cert(bb, &print) != OK)
		    cp2cb (iocbs->out_user, "    Unable to print.\n");
		else {
		    prefixav(print, "    ");
		    for (av = print; av != NULLVP && *av != NULLCP; av++) {
			cp2cb (iocbs->out_user, *av);
			cp2cb (iocbs->out_user, "\n");
		    }
		    FREE_AV(print);
		}
		FREE_BBUF(bb);
	    }
	}
	
	else if (!strcasecmp (*tag, "crl")) {
	    
	    dummybb.data = (unsigned char *) *(tag+1);
	    dummybb.length = strlen(*(tag+1));
	    if (bdecode(&dummybb, &bb) != OK)
		cp2cb (iocbs->out_user, "    Unable to decode.\n");
	    else {
		if (disp_crl(bb, &print) != OK)
		    cp2cb (iocbs->out_user, "    Unable to print.\n");
		else {
		    prefixav(print, "    ");
		    for (av = print; av != NULLVP && *av != NULLCP; av++) {
			cp2cb (iocbs->out_user, *av);
			cp2cb (iocbs->out_user, "\n");
		    }
		    FREE_AV(print);
		}
		FREE_BBUF(bb);
	    }
	}
    }

    cp2cb (iocbs->out_user, "\n");
    
    ret = OK;

 cleanup:
    
    FREE_BBUF(bb);
    return ret;
}
