.TH PEM 1 "October 1994"  "7.0" "TIS/PEM"
.SH NAME
pem \- Privacy Enhanced Mail system
.SH SYNOPSIS
Any TIS/PEM command
.SH DESCRIPTION
TIS/PEM is the name of a privacy enhancement system for mail.  TIS/PEM
consists of many different programs, which are used to enhance and
de-enhance messages.  TIS/PEM has many different interfaces which
range from emacs to the X window system, all of which use the main MH
mail commands.  This allows users to send and receive privacy enhanced
messages with PEM through MH.  You should refer to the
.I
TIS/PEM User's Guide
and the manual pages for the TIS/PEM programs. 
.PP
TIS/PEM is oriented to handle many aspects of privacy enhanced mail.
It will not only enhance and de-enhance privacy enhanced messages, it
will allow you to generate key pairs and build trust relationships.
.PP
The rest of this manual entry is a quick description of commands which
will teach you the basics of TIS/PEM.  You should read the manual
entries for the individual programs for complete documentation, as
well as the manual entries for MH, since TIS/PEM uses it as one of
it's main interfaces.  A good place to start for MH is the command
.B man mh,
followed by the command
.B man mhn
for MIME information.
.PP
To get started using TIS/PEM put the directory in which the pem
programs reside in your
.B $PATH
variable.  This is best done in one of the files: 
.B .profile, login,
or 
.B .cshrc
in your home directory.  (Check the manual entry for the shell you
use, in case you don't know how to do this.)
.PP
.B pemkey
allows you to generate a key pair, the basis for public key
cryptography, and optionally a certificate, the basis for the PEM
certificate hierarchy.
.PP
.B pempass
allows you to change the password that is used to encrypt your private key.
.PP
.B pemlogin

allows you to login to TIS/PEM.  file or supplied on the command line.
This allows you to enter your TIS/PEM password once, and it is valid
until you run the 
.B pemlogout
command.  This is useful when processing many PEM messages, since
it saves you from entering your password every time.
.PP
.B pemlogout
causes you to logout of TIS/PEM if you are currently logged in to
TIS/PEM.  This should be used if you are logged in to TIS/PEM and are
finished processing PEM messages or if you are going to be away from
your terminal for a period of time to prevent someone from sending
privacy enhanced mail from your account.
.PP
.B
sign, verify, encrypt, 
and
.B decrypt
allow you to sign, verify the signature of, encrypt, and decrypt PEM messages,
respectively.  These programs provide the basic PEM functions and require
only a minimal amount of shell script "glue" to integrate with mail user
agents.  TIS/PEM is delivered with the "glue" necessary to use these commands
from within MH.
.PP
.B getkeydata
and
.B savekeydata
round out the commands necessary to generate and process all PEM headers.
They generate and process Certificate and CRL chains and Key headers.
.PP
All of the above commands have their own manual pages.  They can also
be called with the single argument
.B help
to give usage information, e.g.,
.PP
.B sign help
.SH SEE ALSO
.I
TIS/PEM User's Guide
.SH FILES
$HOME/.pemrc,
$HOME/.pemdb

