/*

	R_DH.C - Diffie-Hellman routines for RSAEURO

	Copyright (c) J.S.A.Kapp 1994 - 1995.

	RSAEURO - RSA Library compatible with RSAREF(tm) 2.0.

	All functions prototypes are the Same as for RSAREF(tm).
	To aid compatiblity the source and the files follow the
	same naming comventions that RSAREF(tm) uses.  This should aid
	direct importing to you applications.

	This library is legal everywhere outside the US.  And should
	NOT be imported to the US and used there.

	All Trademarks Acknowledged.

	Diffie-Hellman Key Agreement functions.

	Revision History.
		0.90, First revision, this simply does the required
		Diffie-Hellman key agreement stuff, based heavily on
		RSAREF(tm) and relies heavily on the NN.C routines.

		1.00 23/6/95, Final Release Version
*/

#include "rsaeuro.h"
#include "r_random.h"
#include "nn.h"
#include "prime.h"

		/* Key agreement prep */
#define PREP(x, y, z, a) { \
	NN_Assign (x, y, a);\
	NN_ASSIGN_DIGIT (z, 1, a);\
	NN_Sub (z, t, z, a);\
	NN_Add (x, x, z, a);\
}

/* Generates Diffie-Hellman key agreement parameters. */

int R_GenerateDHParams(params, primeBits, subPrimeBits, randomStruct)
R_DH_PARAMS *params;                       /* new Diffie-Hellman parameters */
unsigned int primeBits;                    /* length of prime in bits */
unsigned int subPrimeBits;                 /* length of subprime in bits */
R_RANDOM_STRUCT *randomStruct;             /* random structure */
{
	int status;
	NN_DIGIT g[MAX_NN_DIGITS], p[MAX_NN_DIGITS], q[MAX_NN_DIGITS],
		t[MAX_NN_DIGITS], u[MAX_NN_DIGITS], v[MAX_NN_DIGITS];
	unsigned int pDigits;

	pDigits = (primeBits + NN_DIGIT_BITS - 1) / NN_DIGIT_BITS;

	/* Generate a subprime q between 2^(subPrimeBits-1) and
		 2^subPrimeBits-1, searching in steps of 2.	 */

	NN_Assign2Exp(t, subPrimeBits-1, pDigits);
	PREP(u, t, v, pDigits);
	NN_ASSIGN_DIGIT(v, 2, pDigits);
	if((status = GeneratePrime (q, t, u, v, pDigits, randomStruct)) != 0)
		return(status);

	/* Generate a prime p between 2^(primeBits-1) and 2^primeBits-1,
		 searching in steps of 2*q. */
	NN_Assign2Exp(t, primeBits-1, pDigits);
	PREP(u, t, v, pDigits);
	NN_LShift(v, q, 1, pDigits);
	if((status = GeneratePrime (p, t, u, v, pDigits, randomStruct)) != 0)
		return(status);

	/* Generate the generator g for subgroup as 2^((p-1)/q) mod p. */

	NN_ASSIGN_DIGIT(g, 2, pDigits);
	NN_Div(t, u, p, pDigits, q, pDigits);
	NN_ModExp(g, g, t, pDigits, p, pDigits);

	params->generatorLen = params->primeLen = DH_PRIME_LEN(primeBits);
	NN_Encode(params->prime, params->primeLen, p, pDigits);
	NN_Encode(params->generator, params->generatorLen, g, pDigits);

	return(IDOK);
}

/* Setup Diffie-Hellman key agreement. Public value has same length
	 as prime. */

int R_SetupDHAgreement(publicValue, privateValue, privateValueLen,
		params, randomStruct)
unsigned char *publicValue;                             /* new public value */
unsigned char *privateValue;                           /* new private value */
unsigned int privateValueLen;                    /* length of private value */
R_DH_PARAMS *params;                           /* Diffie-Hellman parameters */
R_RANDOM_STRUCT *randomStruct;                          /* random structure */
{
	int status;
	NN_DIGIT g[MAX_NN_DIGITS], p[MAX_NN_DIGITS], x[MAX_NN_DIGITS],
		y[MAX_NN_DIGITS];
	unsigned int pDigits, xDigits;

	NN_Decode(p, MAX_NN_DIGITS, params->prime, params->primeLen);
	pDigits = NN_Digits(p, MAX_NN_DIGITS);
	NN_Decode(g, pDigits, params->generator, params->generatorLen);


	/* Generate the private value of key agreement. */

	if((status = R_GenerateBytes(priv                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            