/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef	_X500_
#define	_X500_

#include "asn1.h"

/* useful generic structure */

struct strval {
    char *str;
    unsigned short val;
};

extern unsigned short	strilookup();
extern char		*vallookup();

#define PARSE_ERROR		0x00

/* Define mnemonics for asn attribute types */

#define COMMONNAME		1
#define ORGUNITNAME		2
#define ORGNAME			3
#define STATEORPROVINCE		4
#define COUNTRYNAME		5
#define STREETADDRESS		6
#define POSTALCODE		7
#define POSTALADDRESS		8
#define POSTOFFICEBOX		9
#define SURNAME			10
#define SERIALNUMBER		11
#define LOCALITYNAME		12
#define TITLE			13
#define DESCRIPTION		14
#define SEARCHGUIDE		15
#define BUSINESSCATEGORY	16
#define DELIVERYOFFICENAME	17
#define PHONENUMBER		18
#define TELEXNUMBER		19
#define TELEXTERMINALID		20
#define FAXPHONENUMBER		21
#define X121ADDRESS		22
#define ISDNNUMBER		23
#define REGISTEREDADDRESS	24
#define DESTINATIONINDICATOR	25
#define DELIVERYMETHOD		26
#define PRESENTATIONADDRESS	27
#define APPLICATIONCONTEXT	28
#define MEMBER			29
#define OWNER			30
#define ROLEOCCUPANT		31
#define SEEALSO			32
#define USERPASSWORD		33
#define USERCERTIFICATE		34
#define CACERTIFICATE		35
#define AUTHREVOCATIONLIST	36
#define CERTREVOCATIONLIST	37
#define CROSSCERTIFICATEPAIR	38

/* Define mnemonics for asn attribute syntaxes */

#define DistinguishedName	1
#define ObjectIdentifier	2
#define CaseExactString		3
#define CaseIgnoreString	4
#define PrintableString		5
#define NumericString		6
#define CaseIgnoreList		7
#define Boolean			8
#define Integer			9
#define OctetString		10
#define UTCTime			11
#define PhoneNumber		12

/* Although all attributes are defined above, only those attributes
   that need be supported for distinguished names are assigned below.
   If there is a need for support of additional attribute types, an 
   entry must be created in each of the following structures:

		label_attribute[]
		oidstr_attributes[]
		oidstr_syntax[]

*/

#ifndef	DEFINE_DATA
extern struct strval label_attribute[];
#else	/* DEFINE_DATA */
struct strval label_attribute[] = {

    /* These attributes currently allowed by RFC 1421 */

    "Common Name",			COMMONNAME,
    "CN",				COMMONNAME,
    "Country Name",			COUNTRYNAME,
    "C",				COUNTRYNAME,
    "Locality Name",			LOCALITYNAME,
    "L",				LOCALITYNAME,
    "State or Province Name",		STATEORPROVINCE,
    "ST",				STATEORPROVINCE,
    "Street Address",			STREETADDRESS,
    "SA",				STREETADDRESS,
    "Organization Name",		ORGNAME,
    "O",				ORGNAME,
    "Organizational Unit Name",		ORGUNITNAME,
    "OU",				ORGUNITNAME,

    /* Additional attributes outside RFC 1421 */

    "Post Office Box",			POSTOFFICEBOX,
    "PO Box",				POSTOFFICEBOX,
    "Postal Code",			POSTALCODE,
    "PC",				POSTALCODE,
    "Title",				TITLE,
    "T",				TITLE,
    "Description",			DESCRIPTION,
    "D",				DESCRIPTION,
    "Postal Address",			POSTALADDRESS,
    "PA",				POSTALADDRESS,
    "Telephone Number",			PHONENUMBER,
    "TN",				PHONENUMBER,
    "Telex Number",			TELEXNUMBER,
    "Telex",				TELEXNUMBER,
    "Telex Terminal Identifier",	TELEXTERMINALID,
    "Telex TID",			TELEXTERMINALID,
    "Surname",				SURNAME,
    "S",				SURNAME,
    "Serial Number",			SERIALNUMBER,
    "SN",				SERIALNUMBER,
    "Facsimile Telephone Number",	FAXPHONENUMBER,
    "Fax",				FAXPHONENUMBER,

    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

#ifndef	DEFINE_DATA
extern struct strval oidstr_attribute[];
#else	/* DEFINE_DATA */
struct strval oidstr_attribute[] = {
    "2.5.4.3",                          COMMONNAME,
    "2.5.4.4",                          SURNAME,
    "2.5.4.5",                          SERIALNUMBER,
    "2.5.4.6",                          COUNTRYNAME,
    "2.5.4.7",                          LOCALITYNAME,
    "2.5.4.8",                          STATEORPROVINCE,
    "2.5.4.9",                          STREETADDRESS,
    "2.5.4.10",                         ORGNAME,
    "2.5.4.11",                         ORGUNITNAME,
    "2.5.4.12",                         TITLE,
    "2.5.4.13",                         DESCRIPTION,
    "2.5.4.16",                         POSTALADDRESS,
    "2.5.4.17",                         POSTALCODE,
    "2.5.4.18",                         POSTOFFICEBOX,
    "2.5.4.20",                         PHONENUMBER,
    "2.5.4.21",                         TELEXNUMBER,
    "2.5.4.22",                         TELEXTERMINALID,
    "2.5.4.23",                         FAXPHONENUMBER,

    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

#ifndef	DEFINE_DATA
extern struct strval oidstr_syntax[];
#else	/* DEFINE_DATA */
struct strval oidstr_syntax[] = {
    "2.5.4.3",				CaseIgnoreString,
    "2.5.4.4",				CaseIgnoreString,
    "2.5.4.5",				PrintableString,
    "2.5.4.6",				PrintableString,
    "2.5.4.7",				CaseIgnoreString,
    "2.5.4.8",				CaseIgnoreString,
    "2.5.4.9",				CaseIgnoreString,
    "2.5.4.10",				CaseIgnoreString,
    "2.5.4.11",				CaseIgnoreString,
    "2.5.4.12",				CaseIgnoreString,
    "2.5.4.13",				CaseIgnoreString,
    "2.5.4.16",				PrintableString,
    "2.5.4.17",				CaseIgnoreString,
    "2.5.4.18",				CaseIgnoreString,
    "2.5.4.20",				PhoneNumber,
    "2.5.4.21",				PrintableString,
    "2.5.4.22",				PrintableString,
    "2.5.4.23",				PhoneNumber,

    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

/* We need character set designators to resolve
   potential ambiguity for string valued attributes */

#define PRS		DEFN_PRTS
#define T61S		DEFN_T61S

#ifndef	DEFINE_DATA
extern struct strval label_charset[];
#else	/* DEFINE_DATA */
struct strval label_charset[] = {
    "PRS",			DEFN_PRTS,
    "T61",			DEFN_T61S,
    NULLCP, 0                   /* ZERO is used here */
};
#endif	/* not DEFINE_DATA */

unsigned char		asn_extract();

#endif	/* not _X500_ */
