/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include <stdio.h>
#include <X11/Xlib.h>
#include "xmh.h"

int Ret = 0;
char *wait_user(dialog, ctxt)
Widget dialog;
XtAppContext ctxt;
{
   XEvent report;
   String string;
   Arg args[2];

   XtSetArg(args[0],XtNbackground, "white");
   XtSetArg(args[0],XtNforeground, "white");
   XtSetValues(XtNameToWidget(dialog,"value"), args, 2);

   while (1) {
       XtAppNextEvent(ctxt, &report);
       XtDispatchEvent(report);
       switch (report.type) {
       case ButtonPress:
	  XtAppNextEvent(ctxt, &report);
	  XtDispatchEvent(report);
	  if (Ret == 1) {
	      string = XawDialogGetValueString(dialog);
	      /* Append a <Return> to end of string since Ok button was
		 pressed */
	      strcat(string,"\n");
	      return(string);
	  }
	  break;
        case KeyPress:
	  XtAppNextEvent(ctxt, &report);
	  XtDispatchEvent(report);
	  string = XawDialogGetValueString(dialog);
	  if ((string[strlen(string)-1]==10) ||
	      (string[strlen(string)-1]==13)) {
	      return(string);
	  } 
	  break;
        default:
	  break;
      }
  }
}

void Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    Ret = (int)client_data;
    return;
}


/*************** Note: the following 3 functions are modified versions
		 of the ones which appear in popup.c********************/
		 

static Boolean PositionThePopup(popup, x, y)
    Widget	popup;
    Position	x, y;
{
    /* Hack.  Fix up the position of the popup.  The xmh app defaults file
     * contains an Xmh*Geometry specification; the effects of that on 
     * popups, and the lack of any user-supplied geometry specification for
     * popups, are mitigated here, by giving the popup shell a position.
     * (Xmh*Geometry is needed in case there is no user-supplied default.)
     * Returns True if an explicit geometry was inferred; false if the
     * widget was repositioned to (x,y).
     */

    Arg		args[4];
    String 	top_geom, pop_geom;

    XtSetArg( args[0], XtNgeometry, &top_geom );
    XtGetValues( toplevel, args, 1 );
    XtSetArg( args[0], XtNgeometry, &pop_geom );
    XtGetValues( popup, args, 1);

    if (pop_geom == NULL || pop_geom == top_geom) {
	/* if same db entry, then ... */
	XtSetArg( args[0], XtNgeometry, (String) NULL);
	XtSetArg( args[1], XtNx, x);
	XtSetArg( args[2], XtNy, y);
	XtSetArg( args[3], XtNwinGravity, SouthWestGravity);
	XtSetValues( popup, args, 4);
	return False;
    }
    return True;
}

static void InsureVisibility(popup, popup_child, x, y, centerX, centerY,
			     height, width, border)
    Widget	popup, popup_child;
    Position	x, y;		/* assert: current position = (x,y) */
    Boolean	centerX, centerY;
    Dimension   height, width, border;
{
    Position	root_x, root_y;
    Arg		args[3];

    XtTranslateCoords(popup_child, (Position)0, (Position)0, &root_x, &root_y);
    if (centerX) root_x -= width/2 + border;
    if (centerY) root_y -= height/2 + border;
    if (root_x < 0) root_x = 0;
    if (root_y < 0) root_y = 0;
    border <<= 1;

    if ((int)(root_x + width + border) > WidthOfScreen(XtScreen(toplevel))) {
	root_x = WidthOfScreen(XtScreen(toplevel)) - width - border;
    }
    if ((int)(root_y + height + border) > HeightOfScreen(XtScreen(toplevel))) {
	root_y = HeightOfScreen(XtScreen(toplevel)) - height - border;
    }
    if (root_x != x || root_y != y) {
	XtSetArg(args[0], XtNx, root_x);
	XtSetArg(args[1], XtNy, root_y);
	XtSetValues(popup, args,2);
    }
}

static void DeterminePopupPosition(x_ptr, y_ptr, transFor_return)
    Position	*x_ptr, *y_ptr;
    Widget	*transFor_return; /* return a suitable top level shell */
{
    if (lastInput.win != -1) {
	if (transFor_return) {
	    Widget	source;
	    source = XtWindowToWidget(XtDisplay(toplevel), lastInput.win);
	    while (source && !XtIsWMShell(source))
		source = XtParent(source);
	    *transFor_return = source;
	}
	*x_ptr = lastInput.x;
	*y_ptr = lastInput.y;
    } else {
	Widget	source;
	int i = 0;
	Dimension width, height;
	Arg args[2];

	/* %%% need to keep track of last screen */
	/* guess which screen and use the the center of it */
	while (i < numScrns && !scrnList[i]->mapped)
	    i++;
	source = ((i < numScrns) ? scrnList[i]->parent : toplevel);
	XtSetArg(args[0], XtNwidth, &width);
	XtSetArg(args[1], XtNheight, &height);
	XtGetValues(source, args, 2);
	XtTranslateCoords(source, (Position) (width / 2),
			  (Position) (height / 2), x_ptr, y_ptr);
	if (transFor_return) *transFor_return = source;
    }
}

String dialogb(header)
char *header;
{
    Widget ok, dialog, shell;
    Arg args[4];
    Position x,y;
    int i;
    Dimension height, width, border;
    Boolean positioned;
    String string;

    DeterminePopupPosition(&x, &y, (Widget*)NULL); 
    XtSetArg(args[0], XtNinput, True);
    XtSetArg(args[1], XtNallowShellResize, True);
    shell = XtCreatePopupShell("shell",transientShellWidgetClass,
			       toplevel, args, 2);
    positioned = PositionThePopup(shell, x, y);
    XtSetArg(args[0],XtNlabel,header);
    XtSetArg(args[1],XtNvalue,"");
    dialog= XtCreateManagedWidget("dialog",dialogWidgetClass, shell,
				   args, 2);
    ok = XtCreateManagedWidget("Ok",commandWidgetClass,dialog,NULL,0);
    XtAddCallback(ok,XtNcallback,Quit,(XtPointer)1);
    XtRealizeWidget(toplevel);
    XtPopup(shell, XtGrabNone);
    XtSetArg(args[0],XtNwidth, &width);
    XtSetArg(args[1],XtNheight, &height);
    XtSetArg(args[2],XtNborderWidth, &border);
    XtGetValues(shell,args,3);
    XtPopdown(shell);
    InsureVisibility(shell, dialog, x, y, !positioned, True, height,
		     width, border); 
    XtPopup(shell, XtGrabNone);
    string = wait_user(dialog,XtWidgetToApplicationContext(shell));
    XtPopdown(shell);
    XtDestroyWidget(shell);
    return(string);
}

