/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>
#include <string.h>

#ifdef _MAC_
int _strnicmp(s,t,n)
char *s,*t;
{
    int ch,ch1;
    
    while(*s && *t && n != 0) {
	ch = *s;
	ch1 = *t;
	if (ch >= 'A' && ch <= 'Z') ch += 32;
	if (ch1 >= 'A' && ch1 <= 'Z') ch1 += 32;
	if (ch != ch1)
	    return ch-ch1;
	s++;
	t++;
	n--;
    }
    return *s - *t;
}

int _stricmp(s, t)
char *s,*t;
{
    int len;
    
    len = strlen(s);
    return _strnicmp(s, t, len);
}

int toascii(ch)
int ch;
{
    return ch & 0x7f;
}

static char tmpfnambuf[256];
static int tmpcnt;

char *mktemp(str)
char *str;
{
    FILE *inf;
    
    while(1) {
	sprintf(tmpfnambuf,"%s%06d", str, tmpcnt++);
	if ((inf = fopen(tmpfnambuf,"r")) == NULL)
	    return tmpfnambuf;
	
	fclose(inf);
	if (tmpcnt == 26)
	    break;
    }
    return NULL;
}


#endif /* _MAC_ */


int alarm(tim)
int tim;
{
    return 0;
}

#ifndef _MAC_
int sleep(tim)
int tim;
{
    fprintf(stderr,"Sleep..... press a key");
    getch();
    fprintf(stderr,"\n");
    return 0;
}

int kill()
{
    fprintf(stderr,"\nKill() ... press a key");
    getch();
    fprintf(stderr,"\n");
    moss_exit(1);
}

#endif

int ttyecho(fd, mode)
int fd, mode;
{
    return mode;
}

int strcasecmp(s, t)
char *s, *t;
{
    return _stricmp(s, t);
}

int strncasecmp(s, t, n)
char *s, *t;
int n;
{
    return _strnicmp(s,t,n);
}


/* interfaces for yacc and lex */

int yyerror(s)
char *s;
{
    fprintf(stderr,"\nYYERROR: %s\n", s);
    moss_exit(1);
}

int yywrap()
{
    return 1;
}

int moss_exit(code)
int code;
{
    FILE *errf;
    
    if (code) {
	errf = fopen("MOSSERR.$$$","wb");
	if (errf) {
	    char errbuf[2];
	    errbuf[0] = code;
	    fwrite(errbuf,1,1,errf);
	    fclose(errf);
	}
    }
    exit(code);
}


