/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <sys/stat.h>
#include <errno.h>
#include "general.h"

#include "util.h"

/*
 * return -1 on error, 0 if no error, 1 if check failed
 *
 * if "mode" is less than 0 the permissions check is not done,
 * but it is an error to pass a negative number when creating
 */

filchk(file, mode, make)
char *file;
int mode, make;
{
    struct stat sbuf;
    int fd, mask = -1, mymake = 0;
    int ret = -1;

    if (file == NULLCP || *file == NULLC)
	goto cleanup;

 fagain:
    if (stat(file, &sbuf)) {
	if (errno != ENOENT)
		goto cleanup;

	if ( ! make){
		ret = 1;
		goto cleanup;
	}
	mymake = 1;

	if (mode < 0) {
	    mask = umask(0077);
	    mode = ~mask & 0777;
	}

	if ((fd = open(file, O_WRONLY | O_CREAT, mode)) < 0) {
	    if (mask != -1)
		(void) umask(mask);
	    goto cleanup;
	}

	if (mask != -1)
	    (void) umask(mask);
	else {
	    if (chmod(file, mode)) {
		(void) close(fd);
		(void) unlink(file);
		goto cleanup;
	    }
	}
	
	(void) close(fd);
	goto fagain;
    }

    if ((sbuf.st_mode & S_IFMT) != S_IFREG) {
	if (mymake)
	    (void) unlink(file); /* should never happen */
	goto cleanup;
    }
#ifndef PC
    if (mode != NOPERMS && ((sbuf.st_mode & 0777) | mode) != mode) {
	if (mymake)
	    (void) unlink(file); /* should never happen */
	goto cleanup;
    }

    if (mode != NOPERMS && mode & 0222 && sbuf.st_uid != getuid()) {
	if (mymake)
	    (void) unlink(file); /* should never happen */
	goto cleanup;
    }
#endif /* !PC */

    ret = 0;

cleanup:

    return(ret);
}
