.TH mosskey 1 "March 1995"  "7.1" "TIS/MOSS"
.SH NAME
mosskey \- generate a key pair and optionally a certificate
.SH SYNOPSIS
.B mosskey
private-key-access 
.I access
private-key 
.I data
.PP
or
.PP
.B mosskey 
[private-key-access 
.I access
private-key 
.I data
] serial-number 
.I hex
subject-name 
.I dname
.SH DESCRIPTION
If 
.B serial-number
and
.B subject-name
are supplied,
a public key embodied in a certificate and private key are generated,
otherwise a bare public key and private key are generated.  If 
.B subject-name
and 
.B serial-number
are supplied 
and the rest of the tag/value pairs supplied are found in a user record
in your database, a certificate will be created using the public key
found in that user record and the user record will be updated.
.PP
TIS/MOSS uses a modified user-friendly string representation for distinquished
names.  If you include a subject name, it must use this representation.  
See the 
.B mossdb
man page for information on this representation and the name must be placed
in quotes if it contains any spaces.
.PP
Both
.B private-key-access
and
.B private-key
tag/value pairs must be included.  For now,
.I access 
must be the word 
.B file
and 
.I data
must contained the file name into which the private
key is to be placed.
If 
.I data
does not contain a fully qualified file name (starting at the root --
beginning with a /), the value of the 
.B directory
tailorable tag/value pair will be prepended.  
If the resulting name is still not qualified, the value of the 
.B HOME
environment variable will be prepended.
.PP
Additional tag/value pairs may be included and they will be placed in
the newly created user record.  If this will be a user which you will
use to receive encrypted messages, you should included an
.B alias
tag/value pair with the value set to the value of the tailorable
tag/value pair
.B my-alias
(
.B me
by default).
If this will be your primary user record for creating signatures, you
should include an
.B alias
tag/value pair with the value set to the value of the tailorable tag/value
pair
.B sig-alias
(
.B sig-user
by default).
.PP
It is recommended that you enter a MOSS password to encrypt your
private key when given the chance to enhance its security.  Passwords
(phrases, really) can be arbitrarily long and consist of all
characters not used by the TTY driver.
.PP
.B
If you forget your password, the private key cannot be recovered.
.SH FILES
$HOME/.mossrc,
$HOME/.mossdb
.SH SEE ALSO
mossdb(5), mosspass(1), mossrc(5), moss(1)
.SH BUGS
