/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_kvm.c	1.28 96/08/06 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_conf.h>
#include <skip_ioctl.h>
#include <skip_acl.h>
#include <skip_lib.h>
#include <skip_crypt.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>

int
skip_var_init(char *who, char *if_name)
{

	/*
	 * Get Key encryption algorithms supported
	 */
	if (skip_get_kij_algs(if_name) < 0) {
		return (-1);
	}

	/*
	 * Get Traffic encryption and MAC algorithms supported
	 */
	if (skip_get_kp_algs(if_name) < 0) {
		return (-1);
	}

	/*
	 * Initialize private Kij and Kp algs (locally defined)
	 */
	skip_kp_algs[SKIP_CRYPT_SIMPLECRYPT]		= "simplecrypt";
	skip_kij_algs[SKIP_KIJ_SIMPLECRYPT]		= "simplecrypt";
	skip_kp_algs[SKIP_CRYPT_SAFER_128SK_CBC]	= "Safer-128SK-CBC";
	skip_kij_algs[SKIP_KIJ_SAFER_128SK_CBC]		= "Safer-128SK-CBC";
	skip_kp_algs[SKIP_CRYPT_RC2_40]			= "RC2-40";
	skip_kij_algs[SKIP_KIJ_RC2_40]			= "RC2-40";
	skip_kp_algs[SKIP_CRYPT_RC4_40]			= "RC4-40";
	
	return (0);
}

/*ARGSUSED*/
int
skip_get_kij_algs(char *if_name)
{
	extern boolean_t	skip_supported_kij_algs[];
	extern boolean_t	skip_supported_kij_algs_v1[];
	ioctl_alg_list_t	kij_algs_list;
	int			idx;

	if (skip_get_kij_list(if_name, &kij_algs_list)) {
		return(-1);
	}

	for (idx = 0; idx < SKIP_MAXCRYPTORS; idx++) {
		skip_supported_kij_algs[idx] = 
				kij_algs_list.flag_alg[idx];
		skip_supported_kij_algs_v1[idx] = 
				kij_algs_list.flag_alg_v1[idx];

        }
	return(0);
}

int
skip_get_kp_algs(char *if_name)
{

	extern boolean_t	skip_supported_kp_algs[];
	extern boolean_t	skip_supported_kp_algs_v1[];
	extern boolean_t	skip_supported_mac_algs[];
	ioctl_alg_list_t	skip_algs_list;
	int			idx;

	if (skip_get_crypt_list(if_name, &skip_algs_list)) {
		return(-1);
	}

	for (idx = 0; idx < SKIP_MAXCRYPTORS; idx++) {
		skip_supported_kp_algs[idx] = 
				skip_algs_list.flag_alg[idx];
		skip_supported_kp_algs_v1[idx] = 
				skip_algs_list.flag_alg_v1[idx];

        }
	skip_supported_kp_algs[0] = B_TRUE;

	for (idx = 0; idx < SKIP_MAX_MAC; idx++) {
		if (skip_algs_list.flag_alg_mac[idx]) {
			skip_supported_mac_algs[idx] = B_TRUE;
		}
        }
	skip_supported_mac_algs[0] = B_TRUE;
	return(0);
}

int
skip_bytes_percent(ioctl_key_status_t *kp)
{
	if (kp->max_obytes > 0) {
		return (kp->obytes*100/kp->max_obytes);
	} else {
		return (0);
	}
}
