#include "x8.h"

void encrypt_M8(BYTE PTR table,BYTE PTR roundkeys,
					BYTE PTR data,unsigned datalen,int roundcnt)
{
int i,j;
BYTE p1,c1,p0;

for (i=0;i<roundcnt;i++)
	{
	data[0]=table[roundkeys[i<<1]^data[datalen-1]^data[0]];
	p0=data[1];
	c1=data[1]=table[roundkeys[(i<<1)+1]^data[0]^p0];
	for (j=2;j<datalen;j++)
		{
		p1=p0;
		p0=data[j];
		c1=data[j]=table[p0^p1^c1];
		}
	}
p1=0;
c1=0;
p0=0;
}

void decrypt_M8(BYTE PTR table,BYTE PTR roundkeys,
					BYTE PTR data,unsigned datalen,int roundcnt)
{
int i,j;
BYTE p1,c1,c0;

table=&table[table_size];

for (i=roundcnt-1;i>=0;i--)
	{
	c0=data[1];
	p1=data[1]=table[c0]^roundkeys[(i<<1)+1]^data[0];
	for (j=2;j<datalen;j++)
		{
		c1=c0;
		c0=data[j];
		p1=data[j]=table[c0]^p1^c1;
		}
	data[0]=table[data[0]]^roundkeys[i<<1]^data[datalen-1];
	}
p1=0;
c1=0;
c0=0;
}

void encrypt_IS8(BYTE PTR table,BYTE PTR data,unsigned datalen,int roundcnt)
{
int i,j;
BYTE p1,c1,p0;

p1=data[0];
c1=data[datalen-1];
for (i=0;i<roundcnt;i++)
	{
	for (j=0;j<datalen-1;j++)
		{
		p0=p1;
		p1=data[j+1];
		c1=data[j]=table[((c1^p0)+p1)&255];
		}
	p0=p1;
	p1=data[0];
	c1=data[datalen-1]=table[((c1^p0)+p1)&255];
	}
p1=0;
c1=0;
p0=0;
}

void decrypt_IS8(BYTE PTR table,BYTE PTR data,unsigned datalen,int roundcnt)
{
int i,j;
BYTE p1,c1,c0;

table=&table[table_size];

p1=data[0];
c1=data[datalen-1];
for (i=0;i<roundcnt;i++)
	{
	for (j=datalen-1;j>0;j--)
		{
		c0=c1;
		c1=data[j-1];
		p1=data[j]=(table[c0]-p1)^c1;
		}
	c0=c1;
	c1=data[datalen-1];
	p1=data[0]=(table[c0]-p1)^c1;
	}
p1=0;
c1=0;
c0=0;
}

void encrypt_RS8(BYTE PTR table,BYTE PTR data,unsigned datalen,int roundcnt)
{
int i,j;
BYTE c1;

c1=data[datalen-1];
for (i=0;i<roundcnt;i++)
	for (j=0;j<datalen;j++)	c1=data[j]=table[data[j]^c1];
c1=0;
}

void decrypt_RS8(BYTE PTR table,BYTE PTR data,unsigned datalen,int roundcnt)
{
int i,j;
BYTE c1,c0;

table=&table[table_size];

c0=data[0];
for (i=0;i<roundcnt;i++)
	{
	for (j=1;j<datalen;j++)
		{
		c1=c0;
		c0=data[j];
		data[j]=table[c0]^c1;
		}
	c0=data[0];
	data[0]=table[c0]^data[datalen-1];
	}
c1=0;
c0=0;
}

