COMMENT |
============================================================================
  
  HAVAL.ASM v1.0, Haval Message Digest Transform (22 January 1995)
  (C) Copyright 1995 Robert Rothenburg Walking-Owl
  
    History: 1.0    Original release (Jan 95)
  
  This implementation is based on Yuliang Zheng's <yuliang@cs.uow.edu.au> 
  C sources, which are a bit more readable than the article in AUSCRYPT'92 
  (by Y.Zheng, J.Pieprzyk and J.Seberry).
  
  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with TASM 3.2

PASS            EQU     3       ; number of passes (3, 4 or 5)
HAVALVERSION    EQU     1       ;

__CONTEXT       EQU     1


__COPYINT       EQU     1
__LOCALVARS     EQU     1
__NOSTOR        EQU     1

IFNDEF  PASS
  PASS EQU 3
ENDIF
IF (PASS LT 3) OR (PASS GT 5)
  .ERR ; PASS must be 3,4 or 5 only.
ENDIF

; - Function macros (Note: AND takes precedence over XOR) ------------------

F_1             MACRO   x6,x5,x4,x3,x2,x1,x0
                  mov   eax,    x0
                  xor   eax,    x4
                  and   eax,    x1
                  mov   ebx,    x2
                  and   ebx,    x5
                  xor   eax,    ebx
                  mov   ebx,    x3
                  and   ebx,    x6
                  xor   eax,    ebx
                  xor   eax,    x0
                ENDM

F_2             MACRO   x6,x5,x4,x3,x2,x1,x0
                  mov   eax,    x3
                  not   eax
                  and   eax,    x1  
                  mov   ebx,    x4   
                  and   ebx,    x5  
                  xor   eax,    ebx  
                  xor   eax,    x6  
                  xor   eax,    x0 
                  and   eax,    x2
                  mov   ebx,    x1
                  xor   ebx,    x5
                  and   ebx,    x4
                  xor   eax,    ebx
                  mov   ebx,    x3
                  and   ebx,    x5
                  xor   eax,    ebx
                  xor   eax,    x0
                ENDM

F_3             MACRO   x6,x5,x4,x3,x2,x1,x0
                  mov   eax,    x1
                  and   eax,    x2
                  xor   eax,    x6
                  xor   eax,    x0
                  and   eax,    x3
                  mov   ebx,    x1
                  and   ebx,    x4
                  xor   eax,    ebx
                  mov   ebx,    x2
                  and   ebx,    x5
                  xor   eax,    ebx
                  xor   eax,    x0
                ENDM

F_4             MACRO   x6,x5,x4,x3,x2,x1,x0
                  mov   eax,    x2
                  not   eax
                  and   eax,    x5
                  mov   ebx,    x6
                  not   ebx
                  and   ebx,    x3
                  xor   eax,    ebx
                  xor   eax,    x1
                  xor   eax,    x6
                  xor   eax,    x0
                  and   eax,    x4
                  mov   ebx,    x1
                  and   ebx,    x2
                  xor   ebx,    x5
                  xor   ebx,    x6
                  and   ebx,    x3
                  xor   eax,    ebx
                  mov   ebx,    x2
                  and   ebx,    x6
                  xor   eax,    ebx
                  xor   eax,    x0
                ENDM

F_5             MACRO   x6,x5,x4,x3,x2,x1,x0
                  mov   eax,    x1
                  and   eax,    x2
                  and   eax,    x3
                  mov   ebx,    x5
                  not   ebx
                  xor   eax,    ebx
                  and   eax,    x0
                  mov   ebx,    x1
                  and   ebx,    x4
                  xor   eax,    ebx
                  mov   ebx,    x2
                  and   ebx,    x5
                  xor   eax,    ebx
                  mov   ebx,    x3
                  and   ebx,    x6
                  xor   eax,    ebx
                ENDM

             IF PASS EQ 3
Fphi_1          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_1   x1,x0,x3,x5,x6,x2,x4
                ENDM

Fphi_2          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_2   x4,x2,x1,x0,x5,x3,x6
                ENDM

Fphi_3          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_3   x6,x1,x2,x3,x4,x5,x0
                ENDM
             ELSEIF PASS EQ 4
Fphi_1          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_1   x2,x6,x1,x4,x5,x3,x0
                ENDM

Fphi_2          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_2   x3,x5,x2,x0,x1,x6,x4
                ENDM

Fphi_3          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_3   x1,x4,x3,x6,x0,x2,x5
                ENDM

Fphi_4          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_4   x6,x4,x0,x5,x2,x1,x3
                ENDM

             ELSE
Fphi_1          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_1   x3,x4,x1,x0,x5,x2,x6
                ENDM

Fphi_2          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_2   x6,x2,x1,x0,x3,x4,x5
                ENDM

Fphi_3          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_3   x2,x6,x0,x4,x3,x1,x5
                ENDM

Fphi_4          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_4   x1,x5,x3,x2,x0,x4,x6
                ENDM

Fphi_5          MACRO   x6,x5,x4,x3,x2,x1,x0             
                  F_5   x2,x5,x0,x6,x4,x3,x1
                ENDM
             ENDIF
                    
FF_1            MACRO   x7,x6,x5,x4,x3,x2,x1,x0,w
                  Fphi_1 x6,x5,x4,x3,x2,x1,x0
                  ror   eax,    7
                  mov   ebx,    x7
                  ror   ebx,    11
                  add   eax,    ebx
                  add   eax,    w
                  mov   x7,     eax
                ENDM

FF_2            MACRO   x7,x6,x5,x4,x3,x2,x1,x0,w,c
                  Fphi_2 x6,x5,x4,x3,x2,x1,x0
                  ror   eax,    7
                  mov   ebx,    x7
                  ror   ebx,    11
                  add   eax,    ebx
                  add   eax,    w
                  add   eax,    c
                  mov   x7,     eax
                ENDM

FF_3            MACRO   x7,x6,x5,x4,x3,x2,x1,x0,w,c
                  Fphi_3 x6,x5,x4,x3,x2,x1,x0
                  ror   eax,    7
                  mov   ebx,    x7
                  ror   ebx,    11
                  add   eax,    ebx
                  add   eax,    w
                  add   eax,    c
                  mov   x7,     eax
                ENDM

              IF PASS GT 3
FF_4            MACRO   x7,x6,x5,x4,x3,x2,x1,x0,w,c
                  Fphi_4 x6,x5,x4,x3,x2,x1,x0
                  ror   eax,    7
                  mov   ebx,    x7
                  ror   ebx,    11
                  add   eax,    ebx
                  add   eax,    w
                  add   eax,    c
                  mov   x7,     eax
                ENDM

               IF PASS EQ 5
FF_5            MACRO   x7,x6,x5,x4,x3,x2,x1,x0,w,c
                  Fphi_5 x6,x5,x4,x3,x2,x1,x0
                  ror   eax,    7
                  mov   ebx,    x7
                  ror   ebx,    11
                  add   eax,    ebx
                  add   eax,    w
                  add   eax,    c
                  mov   x7,     eax
                ENDM
               ENDIF
              ENDIF

A         EQU       <DWORD PTR es: [di]>    ; chaining variables
B         EQU       <DWORD PTR es: [di+4]>  ;
C         EQU       <DWORD PTR es: [di+8]>  ;
D         EQU       <DWORD PTR es: [di+12]> ;
E         EQU       <DWORD PTR es: [di+16]> ;
F         EQU       <DWORD PTR es: [di+20]> ;
G         EQU       <DWORD PTR es: [di+24]> ;
H         EQU       <DWORD PTR es: [di+28]> ;

W         EQU       <DWORD PTR ds: [si]>    ;
        
        IFDEF   __CONTEXT
ctxlobits EQU       <DWORD PTR es: [di][32]> ; low  no. bits count
ctxhibits EQU       <DWORD PTR es: [di][36]> ; high  "   "     "
ctxinput  EQU       <DWORD PTR es: [di][40]> ; context input buffer
ctxinfo   EQU       <WORD PTR es: [di][158]>
ctxlofin  EQU       <DWORD PTR es: [di][160]>
ctxhifin  EQU       <DWORD PTR es: [di][164]>

; HavalContext structure is as follows:
;
;   unsigned long buf[8]                ; 32 bytes, current hash value
;   unsigned long bits[2]               ; current count of bits
;   unsigned char in[128]               ; current buffer
;
; Note that Haval requires a different context type that SHA or MD4, etc.
; (This implementation does not use the same context type as in Yuliang 
; Zheng's sources, which have a separate buffer for unhashed data.)

; (See note in MD5.ASM about optimizations.)

        ENDIF
                
; - Miscellaneous macros: --------------------------------------------------

STOR      MACRO     dest, src
           mov      eax,  src
          IFDEF     __LOCALVARS
            mov     dest, eax
          ELSE        
            mov     cs: dest, eax
          ENDIF       
         ENDM        

ADDD     MACRO      i, j      ; eax=j; i=i+eax
           mov      eax, j
           add      i, eax
         ENDM        
                    
      IFDEF     __CONTEXT
MCPY     MACRO                    
           LOCAL        @0
           cld
           shr          cx,     1
           jnc          @0
           movsb
 @0:       rep          movsw
         ENDM

MSET     MACRO             
           LOCAL        @0
           xor          ax,     ax
           shr          cx,     1
           jnc          @0
           stosb
 @0:       rep          stosw
         ENDM
      
XFORM    MACRO         
           pusha
           push        es
           add         di,     40
           push        di
           push        es
           push        dx
          IFDEF      __FASTCALLS  
           push        cs
           mov         ax, OFFSET HavalTransform
           call        ax
          ELSE
           call        cs: HavalTransform
          ENDIF
           popa
         ENDM
      ENDIF
                
                DOSSEG
                .MODEL  LARGE
                .386

                .CODE

; - Haval Constants: -------------------------------------------------------

const2_01         EQU     452821E6h       ; Pass 2
const2_02         EQU     38D01377h
const2_03         EQU    0BE5466CFh
const2_04         EQU     34E90C6Ch
const2_05         EQU    0C0AC29B7h
const2_06         EQU    0C97C50DDh
const2_07         EQU     3F84D5B5h
const2_08         EQU    0B5470917h
const2_09         EQU     9216D5D9h
const2_10         EQU     8979FB1Bh
const2_11         EQU    0D1310BA6h
const2_12         EQU     98DFB5ACh
const2_13         EQU     2FFD72DBh
const2_14         EQU    0D01ADFB7h
const2_15         EQU    0B8E1AFEDh
const2_16         EQU     6A267E96h
const2_17         EQU    0BA7C9045h
const2_18         EQU    0F12C7F99h
const2_19         EQU     24A19947h
const2_20         EQU    0B3916CF7h
const2_21         EQU      801F2E2h
const2_22         EQU     858EFC16h
const2_23         EQU     636920D8h
const2_24         EQU     71574E69h
const2_25         EQU    0A458FEA3h
const2_26         EQU    0F4933D7Eh
const2_27         EQU     0D95748Fh
const2_28         EQU     728EB658h
const2_29         EQU     718BCD58h
const2_30         EQU     82154AEEh
const2_31         EQU     7B54A41Dh
const2_32         EQU    0C25A59B5h
const3_01         EQU     9C30D539h       ; Pass 3
const3_02         EQU     2AF26013h
const3_03         EQU    0C5D1B023h
const3_04         EQU     286085F0h
const3_05         EQU    0CA417918h
const3_06         EQU    0B8DB38EFh
const3_07         EQU     8E79DCB0h
const3_08         EQU     603A180Eh
const3_09         EQU     6C9E0E8Bh
const3_10         EQU    0B01E8A3Eh
const3_11         EQU    0D71577C1h
const3_12         EQU    0BD314B27h
const3_13         EQU     78AF2FDAh
const3_14         EQU     55605C60h
const3_15         EQU    0E65525F3h
const3_16         EQU    0AA55AB94h
const3_17         EQU     57489862h
const3_18         EQU     63E81440h
const3_19         EQU     55CA396Ah
const3_20         EQU     2AAB10B6h
const3_21         EQU    0B4CC5C34h
const3_22         EQU     1141E8CEh
const3_23         EQU    0A15486AFh
const3_24         EQU     7C72E993h
const3_25         EQU    0B3EE1411h
const3_26         EQU     636FBC2Ah
const3_27         EQU     2BA9C55Dh
const3_28         EQU     741831F6h
const3_29         EQU    0CE5C3E16h
const3_30         EQU     9B87931Eh
const3_31         EQU    0AFD6BA33h
const3_32         EQU     6C24CF5Ch
               IF PASS GT 3
const4_01         EQU     7A325381h       ; Pass 4
const4_02         EQU     28958677h
const4_03         EQU     3B8F4898h
const4_04         EQU     6B4BB9AFh
const4_05         EQU    0C4BFE81Bh
const4_06         EQU     66282193h
const4_07         EQU     61D809CCh
const4_08         EQU    0FB21A991h
const4_09         EQU     487CAC60h
const4_10         EQU     5DEC8032h
const4_11         EQU    0EF845D5Dh
const4_12         EQU    0E98575B1h
const4_13         EQU    0DC262302h
const4_14         EQU    0EB651B88h
const4_15         EQU     23893E81h
const4_16         EQU    0D396ACC5h
const4_17         EQU     0F6D6FF3h
const4_18         EQU     83F44239h
const4_19         EQU     2E0B4482h
const4_20         EQU    0A4842004h
const4_21         EQU     69C8F04Ah
const4_22         EQU     9E1F9B5Eh
const4_23         EQU     21C66842h
const4_24         EQU    0F6E96C9Ah
const4_25         EQU     670C9C61h
const4_26         EQU    0ABD388F0h
const4_27         EQU     6A51A0D2h
const4_28         EQU    0D8542F68h
const4_29         EQU     960FA728h
const4_30         EQU    0AB5133A3h
const4_31         EQU     6EEF0B6Ch
const4_32         EQU     137A3BE4h
                ENDIF
                IF PASS EQ 5
const5_01         EQU    0BA3BF050h       ; Pass 5
const5_02         EQU     7EFB2A98h
const5_03         EQU    0A1F1651Dh
const5_04         EQU     39AF0176h
const5_05         EQU     66CA593Eh
const5_06         EQU     82430E88h
const5_07         EQU     8CEE8619h
const5_08         EQU     456F9FB4h
const5_09         EQU     7D84A5C3h
const5_10         EQU     3B8B5EBEh
const5_11         EQU    0E06F75D8h
const5_12         EQU     85C12073h
const5_13         EQU     401A449Fh
const5_14         EQU     56C16AA6h
const5_15         EQU     4ED3AA62h
const5_16         EQU     363F7706h
const5_17         EQU     1BFEDF72h
const5_18         EQU     429B023Dh
const5_19         EQU     37D0D724h
const5_20         EQU    0D00A1248h
const5_21         EQU    0DB0FEAD3h
const5_22         EQU     49F1C09Bh
const5_23         EQU     075372C9h
const5_24         EQU     80991B7Bh
const5_25         EQU     25D479D8h
const5_26         EQU    0F6E8DEF7h
const5_27         EQU    0E3FE501Ah
const5_28         EQU    0B6794C3Bh
const5_29         EQU     976CE0BDH
const5_30         EQU      4C006BAh
const5_31         EQU    0C1A94FB6h
const5_32         EQU     409F60C4h
                ENDIF


; - Temporary Registers: ---------------------------------------------------

                    IFNDEF      __LOCALVARS
t0                    LABEL     DWORD
                      DD        (?)
t1                    LABEL     DWORD
                      DD          (?)
t2                    LABEL     DWORD
                      DD          (?)
t3                   LABEL     DWORD
                      DD          (?)
t4                    LABEL     DWORD
                      DD          (?)
t5                   LABEL     DWORD
                      DD          (?)
t6                    LABEL     DWORD
                      DD          (?)
t7                    LABEL     DWORD
                      DD          (?)
                    ENDIF



; - Initializate Digest: ---------------------------------------------------
                 IFNDEF __TRANSFORMONLY
; if __TRANSFORMONLY defined, no HavalInit routine will assembled.
                    PUBLIC      PASCAL HavalInit
HavalInit           PROC        PASCAL FAR digest: DWORD
                    IFDEF     __COPYINIT
                      push      ds
                      mov       ax,       cs
                      mov       ds,       ax
                      mov       si,       OFFSET initial_values
                    ENDIF       
                    les         di,       digest
                    IFNDEF    __COPYINIT
                      mov       A,      243F6A88h
                      mov       B,      85A308D3h
                      mov       C,      13198A2Eh
                      mov       D,      03707344h
                      mov       E,     0A4093822h
                      mov       F,      299F31D0h
                      mov       G,      082EFA98h
                      mov       H,     0EC4E6C89h
                     IFDEF    __CONTEXT 
                      mov     ctxlobits, 0
                      mov     ctxhibits, 0  
                     ENDIF
                     ELSE 
                     IFDEF    __CONTEXT 
                      mov       cx,    10
                     ELSE
                      mov       cx,     8
                     ENDIF
                      rep         movsd
                      pop         ds
                    ENDIF       
                    ret

                    IFDEF       __COPYINIT
initial_values      LABEL     DWORD
  DD                  243F6A88h
  DD                  85A308D3h
  DD                  13198A2Eh
  DD                  03707344h
  DD                 0A4093822h
  DD                  299F31D0h
  DD                  082EFA98h
  DD                 0EC4E6C89h
IFDEF __CONTEXT
  DD  2 DUP (?)         
ENDIF
                    ENDIF

HavalInit     ENDP

; - Update Context Buffer: -------------------------------------------------
                 IFDEF   __CONTEXT
                    PUBLIC      PASCAL HavalUpdate
HavalUpdate         PROC        PASCAL FAR ctx: DWORD, buff: DWORD, len: WORD
                    push        ds
                    lds         si,     buff
                    les         di,     ctx
 @0:                cmp         len,    0
                    jz          SHORT   @3
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     7Fh
                    mov         cx,     80h
                    sub         cx,     ax
                    cmp         cx,     len
                    jna         SHORT @1
                    mov         cx,    len
 @1:                sub         len,   cx
                    mov         bx,    ax
                    mov         ax,    cx
                    and         eax,   0FFFFh
                    shl         eax,    3
                    add         ctxlobits, eax
                    adc         ctxhibits, 0  
                    mov         dx,     di
                    add         di,     40
                    add         di,     bx
                    add         bx,     cx
                    MCPY
                    mov         di,     dx
                    cmp         bx,     80h
                    jnz         SHORT @2
                    XFORM
 @2:                jmp         SHORT @0
 @3:                   
                    pop          ds
                    ret
HavalUpdate         ENDP

; - Fingerprint Length Tailoring Macros: -----------------------------------

TAILOR128             MACRO     a, h, g, f, e, s                     
                      mov       eax,    h
                      and       eax,    000000FFh
                      mov       ebx,    g
                      and       ebx,   0FF000000h
                      or        eax,    ebx
                      mov       ebx,    f
                      and       ebx,    00FF0000h
                      or        eax,    ebx
                      mov       ebx,    e
                      and       ebx,    0000FF00h
                      or        eax,    ebx
                      IF        s
                        ror     eax,    s
                      ENDIF
                      add       a,      eax
                      ENDM

TAILOR224             MACRO     a, s, m
                      mov       eax,    H
                      IF        s
                        shr     eax,    s
                      ENDIF
                      and       eax,    m
                      add       a,      eax
                      ENDM

; - Wrap-up Context Buffer: ------------------------------------------------

                    PUBLIC      PASCAL HavalFinal
HavalFinal          PROC        PASCAL FAR digest: DWORD, FPTLEN: WORD, ctx: DWORD
                    push        ds
                    les         di,     ctx
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     7Fh
                    mov         bx,     ax
                    mov         dx,     di
                    add         di,     40
                    add         di,     bx
                    mov         al,     80h  ;
                    cld
                    stosb
                    inc         bx
                    mov         cx,     80h
                    sub         cx,     bx
                    cmp         bx,     76h
                    jb          SHORT @4
                    MSET
                    mov         di,     dx
                    XFORM
                    add         di,     40
                    mov         cx,     76h             
 @4:                MSET
                    mov         di,     dx
                    mov         ax,     FPTLEN
                    shl         ax,     6
                    mov         bx,     PASS
                    shl         bx,     3
                    or          ax,     bx
                    or          ax,     HAVALVERSION
                    mov         ctxinfo, ax
                    STOR        ctxlofin, ctxlobits
                    STOR        ctxhifin, ctxhibits
                    XFORM
; - (Tailor output) --------------------------------------------------------
                    mov         cx,     FPTLEN
                    shr         cx,     3
                    cmp         cx,     32              ; 256 bits
                    je          notailoring
                    cmp         cx,     16
                    jne         tailor160bits
 tailor128bits:     TAILOR128 A, H, G, F, E, 8
                    TAILOR128 B, G, F, E, H, 16
                    TAILOR128 C, F, E, H, G, 24
                    TAILOR128 D, E, H, G, F, 0
                    jmp         notailoring
 tailor160bits:     cmp         cx,     20
                    jne         tailor192bits
                    mov         eax,    H
                    and         eax,    3Fh
                    mov         ebx,    G
                    and         ebx,    (7Fh SHL 25)
                    or          eax,    ebx
                    mov         ebx,    F
                    and         ebx,    (3Fh SHL 19)
                    or          eax,    ebx
                    ror         eax,    19
                    add         A,      eax     ;
                    mov         eax,    H
                    and         eax,    (3Fh SHL 6)
                    mov         ebx,    G
                    and         ebx,    3Fh
                    or          eax,    ebx
                    mov         ebx,    F
                    and         ebx,    (7Fh SHL 25)
                    or          eax,    ebx
                    ror         eax,    25
                    add         B,      eax     ;
                    mov         eax,    H
                    and         eax,    (7Fh SHL 12)
                    mov         ebx,    G
                    and         ebx,    (3Fh SHL 6)
                    or          eax,    ebx
                    mov         ebx,    F
                    and         ebx,    3Fh
                    or          eax,    ebx
                    add         C,      eax     ;
                    mov         eax,    H
                    and         eax,    (3Fh SHL 19)
                    mov         ebx,    G
                    and         ebx,    (7Fh SHL 12)
                    or          eax,    ebx
                    mov         ebx,    F
                    and         ebx,    (3Fh SHL 6)
                    or          eax,    ebx
                    shr         eax,    6
                    add         D,      eax
                    mov         eax,    H
                    and         eax,    (7Fh SHL 25)
                    mov         ebx,    G
                    and         ebx,    (3Fh SHL 19)
                    or          eax,    ebx
                    mov         ebx,    F
                    and         ebx,    (7Fh SHL 12)
                    or          eax,    ebx
                    shr         eax,    12
                    add         E,      eax
                    jmp         notailoring
 tailor192bits:     cmp         cx,     24
                    jne         tailor224bits
                    mov         eax,    H
                    and         eax,    1Fh
                    mov         ebx,    G
                    and         ebx,    (3Fh SHL 26)
                    or          eax,    ebx
                    ror         eax,    26
                    add         A,      eax
                    mov         eax,    H
                    and         eax,    (1Fh SHL 5)
                    mov         ebx,    G
                    and         ebx,    1Fh
                    or          eax,    ebx
                    add         B,      eax
                    mov         eax,    H
                    and         eax,    (3Fh SHL 10)
                    mov         ebx,    G
                    and         ebx,    (1Fh SHL 5)
                    or          eax,    ebx
                    shr         eax,    5
                    add         C,      eax
                    mov         eax,    H
                    and         eax,    (1Fh SHL 16)
                    mov         ebx,    G
                    and         ebx,    (3Fh SHL 10)
                    or          eax,    ebx
                    shr         eax,    10
                    add         D,      eax
                    mov         eax,    H
                    and         eax,    (1Fh SHL 21)
                    mov         ebx,    G
                    and         ebx,    (1Fh SHL 16)
                    or          eax,    ebx
                    shr         eax,    16
                    add         E,      eax
                    mov         eax,    H
                    and         eax,    (3Fh SHL 26)
                    mov         ebx,    G
                    and         ebx,    (1Fh SHL 21)
                    or          eax,    ebx
                    shr         eax,    21
                    add         F,      eax
                    jmp         SHORT   notailoring
 tailor224bits:     cmp         cx,     28
                    jne         SHORT   notailoring
                    TAILOR224   A, 27, 1Fh
                    TAILOR224   B, 22, 1Fh
                    TAILOR224   C, 18, 0Fh
                    TAILOR224   D, 13, 1Fh
                    TAILOR224   E,  9, 0Fh
                    TAILOR224   F,  4, 1Fh
                    TAILOR224   G,  0, 0Fh
 notailoring:       mov         si,     di
                    mov         ax,     es
                    mov         ds,     ax
                    les         di,     digest
                    MCPY
                    mov         es,     ax         ; wipe buffer in case
                    mov         di,     dx         ; there is anything
                    mov         cx,     (32+8+128) ; sensitive
                    MSET
                    pop         ds
                    ret
HavalFinal          ENDP
                 ENDIF
               ENDIF

; - Haval Transformation: --------------------------------------------------

                PUBLIC  PASCAL HavalTransform
HavalTransform  PROC    PASCAL FAR hashdata: DWORD, digest: DWORD
                  IFDEF          __LOCALVARS
                    LOCAL       t0: DWORD, t1: DWORD, t2: DWORD, t3: DWORD, t4: DWORD, t5: DWORD, t6: DWORD, t7: DWORD
                  ENDIF       
                    push        ds
                    IFDEF          __NOSTOR
                      lds         si,       digest
                      IFDEF          __LOCALVARS
                        lea         di,     OFFSET t0
                        mov         ax,     ss
                      ELSE        
                        mov         di,     OFFSET t0
                        mov         ax,     cs
                      ENDIF       
                      mov         es,       ax
                      mov         cx,       8
                      cld         
                      rep         movsd
                    ENDIF       
                    lds         si,         hashdata      ; *data[128]
                    les         di,         digest        ; *hash[32]
                    IFNDEF      __NOSTOR
                      STOR      t0,       A             ;
                      STOR      t1,       B
                      STOR      t2,       C
                      STOR      t3,       D
                      STOR      t4,       E
                      STOR      t5,       F
                      STOR      t6,       G
                      STOR      t7,       H
                    ENDIF

; - Pass 1 -----------------------------------------------------------------

        FF_1        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*0]
        FF_1        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*1]
        FF_1        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*2]
        FF_1        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*3]
        FF_1        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*4]
        FF_1        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*5]
        FF_1        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*6]
        FF_1        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*7]

        FF_1        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*8]
        FF_1        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*9]
        FF_1        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*10]
        FF_1        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*11]
        FF_1        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*12]
        FF_1        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*13]
        FF_1        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*14]
        FF_1        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*15]

        FF_1        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*16]
        FF_1        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*17]
        FF_1        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*18]
        FF_1        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*19]
        FF_1        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*20]
        FF_1        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*21]
        FF_1        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*22]
        FF_1        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*23]

        FF_1        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*24]
        FF_1        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*25]
        FF_1        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*26]
        FF_1        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*27]
        FF_1        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*28]
        FF_1        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*29]
        FF_1        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*30]
        FF_1        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*31]

; - Pass 2 -----------------------------------------------------------------

        FF_2        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*5], const2_01
        FF_2        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*14], const2_02
        FF_2        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*26], const2_03
        FF_2        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*18], const2_04
        FF_2        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*11], const2_05
        FF_2        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*28], const2_06
        FF_2        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*7], const2_07
        FF_2        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*16], const2_08

        FF_2        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*0], const2_09
        FF_2        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*23], const2_10
        FF_2        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*20], const2_11
        FF_2        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*22], const2_12
        FF_2        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*1], const2_13
        FF_2        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*10], const2_14
        FF_2        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*4], const2_15
        FF_2        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*8], const2_16

        FF_2        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*30], const2_17
        FF_2        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*3], const2_18
        FF_2        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*21], const2_19
        FF_2        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*9], const2_20
        FF_2        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*17], const2_21
        FF_2        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*24], const2_22
        FF_2        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*29], const2_23
        FF_2        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*6], const2_24

        FF_2        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*19], const2_25
        FF_2        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*12], const2_26
        FF_2        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*15], const2_27
        FF_2        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*13], const2_28
        FF_2        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*2], const2_29
        FF_2        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*25], const2_30
        FF_2        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*31], const2_31
        FF_2        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*27], const2_32

; - Pass 3 -----------------------------------------------------------------

        FF_3        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*19], const3_01
        FF_3        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*9], const3_02
        FF_3        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*4], const3_03
        FF_3        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*20], const3_04
        FF_3        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*28], const3_05
        FF_3        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*17], const3_06
        FF_3        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*8], const3_07
        FF_3        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*22], const3_08

        FF_3        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*29], const3_09
        FF_3        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*14], const3_10
        FF_3        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*25], const3_11
        FF_3        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*12], const3_12
        FF_3        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*24], const3_13
        FF_3        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*30], const3_14
        FF_3        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*16], const3_15
        FF_3        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*26], const3_16

        FF_3        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*31], const3_17
        FF_3        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*15], const3_18
        FF_3        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*7], const3_19
        FF_3        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*3], const3_20
        FF_3        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*1], const3_21
        FF_3        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*0], const3_22
        FF_3        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*18], const3_23
        FF_3        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*27], const3_24

        FF_3        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*13], const3_25
        FF_3        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*6], const3_26
        FF_3        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*21], const3_27
        FF_3        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*10], const3_28
        FF_3        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*23], const3_29
        FF_3        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*11], const3_30
        FF_3        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*5], const3_31
        FF_3        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*2], const3_32

; - Pass 4 -----------------------------------------------------------------
                IF (PASS GT 3)
        FF_4        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*24], const4_01
        FF_4        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*4], const4_02
        FF_4        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*0], const4_03
        FF_4        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*14], const4_04
        FF_4        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*2], const4_05
        FF_4        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*7], const4_06
        FF_4        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*28], const4_07
        FF_4        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*23], const4_08

        FF_4        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*26], const4_09
        FF_4        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*6], const4_10
        FF_4        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*30], const4_11
        FF_4        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*20], const4_12
        FF_4        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*18], const4_13
        FF_4        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*25], const4_14
        FF_4        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*19], const4_15
        FF_4        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*3], const4_16

        FF_4        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*22], const4_17
        FF_4        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*11], const4_18
        FF_4        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*31], const4_19
        FF_4        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*21], const4_20
        FF_4        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*8], const4_21
        FF_4        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*27], const4_22
        FF_4        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*12], const4_23
        FF_4        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*9], const4_24

        FF_4        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*1], const4_25
        FF_4        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*29], const4_26
        FF_4        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*5], const4_27
        FF_4        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*15], const4_28
        FF_4        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*17], const4_29
        FF_4        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*10], const4_30
        FF_4        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*16], const4_31
        FF_4        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*13], const4_32
                ENDIF
; - Pass 5 -----------------------------------------------------------------
                IF (PASS EQ 5)
        FF_5        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*27], const5_01
        FF_5        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*3], const5_02
        FF_5        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*21], const5_03
        FF_5        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*26], const5_04
        FF_5        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*17], const5_05
        FF_5        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*11], const5_06
        FF_5        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*20], const5_07
        FF_5        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*29], const5_08

        FF_5        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*19], const5_09
        FF_5        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*0], const5_10
        FF_5        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*12], const5_11
        FF_5        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*7], const5_12
        FF_5        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*13], const5_13
        FF_5        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*8], const5_14
        FF_5        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*31], const5_15
        FF_5        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*10], const5_16

        FF_5        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*5], const5_17
        FF_5        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*9], const5_18
        FF_5        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*14], const5_19
        FF_5        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*30], const5_20
        FF_5        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*18], const5_21
        FF_5        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*6], const5_22
        FF_5        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*28], const5_23
        FF_5        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*24], const5_24

        FF_5        t7, t6, t5, t4, t3, t2, t1, t0, w.[4*2], const5_25
        FF_5        t6, t5, t4, t3, t2, t1, t0, t7, w.[4*23], const5_26
        FF_5        t5, t4, t3, t2, t1, t0, t7, t6, w.[4*16], const5_27
        FF_5        t4, t3, t2, t1, t0, t7, t6, t5, w.[4*22], const5_28
        FF_5        t3, t2, t1, t0, t7, t6, t5, t4, w.[4*4], const5_29
        FF_5        t2, t1, t0, t7, t6, t5, t4, t3, w.[4*1], const5_30
        FF_5        t1, t0, t7, t6, t5, t4, t3, t2, w.[4*25], const5_31
        FF_5        t0, t7, t6, t5, t4, t3, t2, t1, w.[4*15], const5_32
                ENDIF
; --------------------------------------------------------------------------
                    ADDD        A,      t0
                    ADDD        B,      t1
                    ADDD        C,      t2
                    ADDD        D,      t3
                    ADDD        E,      t4
                    ADDD        F,      t5
                    ADDD        G,      t6
                    ADDD        H,      t7
                    pop   ds
                    ret
HavalTransform    ENDP

                END

