COMMENT |
============================================================================
  
  SHA.ASM v2.0, Secure Hash Algorithm Transform (21 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl
  
    History: 1.0    Original release (16 Oct 94)
             2.0    ASM code rewritten (Jan 95).

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with TASM 3.2

; - SHA Assembly Options (Conditional Defines): ----------------------------

__CONTEXT           EQU       1     ; Use SHSInfo structure
;;__REVISED         EQU       1     ; Calculate revised SHS

; Miscellaneous optimizations:

;;__USE486BSWAP     EQU         1   ; Use 486 BSWAP instruction (faster)
__LOCALVARS         EQU         1   ; Locals in STACK (otherwise in CODE)
__NOPROCS           EQU         1   ; Use macros not PROCs for F-I funcs.
__FASTERMETHOD      EQU         1   ; Optimized calculations for F and G (*)
__COPYINIT          EQU         1   ; 
__FASTCALLS         EQU         1   ;

; __FASTERMETHOD is based on recommendations in NIST SHA specification

; - SHA Unconditional Defines: ---------------------------------------------

__NOSTOR            EQU         1   ; Copy A,B,C,D regs. as block (faster?)
__MISCOPT           EQU         1   ; Misc. optimization for H and I func

A         EQU       <DWORD PTR es: [di]>    ; chaining variables
B         EQU       <DWORD PTR es: [di+4]>  ;
C         EQU       <DWORD PTR es: [di+8]>  ;
D         EQU       <DWORD PTR es: [di+12]> ;
E         EQU       <DWORD PTR es: [di+16]> ;

X         EQU       <DWORD PTR ds: [si]>    ;

        IFDEF   __CONTEXT
ctxlobits EQU       <DWORD PTR es: [di][20]> ; low  no. bits count
ctxhibits EQU       <DWORD PTR es: [di][24]> ; high  "   "     "
ctxinput  EQU       <DWORD PTR es: [di][28]> ; context input buffer

ctxlofin  EQU       <DWORD PTR es: [di][88]> ; (*) Bigendian
ctxhifin  EQU       <DWORD PTR es: [di][84]>

; SHSInfo structure is as follows:
;
;   unsigned long buf[5]                ; 20 bytes, current hash value
;   unsigned long bits[2]               ; current count of bits
;   unsigned char in[64]                ; current buffer
;
; (See note in MD5.ASM about optimizations.)

        ENDIF


; - Miscellaneous macros: --------------------------------------------------

STOR      MACRO     dest, src
           mov      eax,  src
          IFDEF     __LOCALVARS
            mov     dest, eax
          ELSE
            mov     cs: dest, eax
          ENDIF       
         ENDM        

ADDD     MACRO      i, j      ; eax=j; i=i+eax
           mov      eax, j
           add      i, eax
         ENDM        

      IFDEF     __CONTEXT
MCPY     MACRO
           LOCAL        @0
           cld
           shr          cx,     1
           jnc          @0
           movsb
 @0:       rep          movsw
         ENDM

MSET     MACRO             
           LOCAL        @0
           xor          ax,     ax
           shr          cx,     1
           jnc          @0
           stosb
 @0:       rep          stosw
         ENDM
      
XFORM    MACRO         
           pusha
           push        es
           add         di,     28
           push        di
           push        es
           push        dx
          IFDEF      __FASTCALLS  
           push        cs
           mov         ax, OFFSET SHATransform
           call        ax
          ELSE
           call        cs: SHATransform
          ENDIF
           popa
         ENDM
      ENDIF

BSWAP386 MACRO                   ; switch endianess of 32-bit word
          IFDEF __USE486BSWAP
           bswap      eax        ; faster on an 80486 machine
          ELSE
           xchg       al, ah
           rol        eax, 16
           xchg       al, ah
          ENDIF
         ENDM

                    DOSSEG
                    .MODEL      LARGE
                    .486

                    .CODE

; - Temporary Registers: ---------------------------------------------------

                    IFNDEF      __LOCALVARS
AA                    LABEL     DWORD
                      DD          (?)
BB                    LABEL     DWORD
                      DD          (?)
CC                    LABEL     DWORD
                      DD          (?)
DD0                   LABEL     DWORD
                      DD          (?)
EE                    LABEL     DWORD
                      DD          (?)
W                     LABEL     DWORD
                      DD   80 DUP (?)
temp                  LABEL     DWORD        ; moved prior to macros so that
                      DD          (?)        ; TASM can work in one pass
                    ENDIF

; - Auxiliary function F(x,y,z)=xy v not(x)z -------------------------------

; if __FASTERMETHOD is defined, F(x,y,z)=z xor (x)(y xor z)

; result = eax, x = ebx, y = ecx, z = edx

                    IFDEF          __NOPROCS
F                     MACRO     
                    ELSE        
F                     PROC      NEAR
                    ENDIF       
                    IFDEF          __FASTERMETHOD
                      mov         eax,      ecx
                      xor         eax,      edx
                      and         eax,      ebx
                      xor         eax,      edx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      not         ebx
                      and         ebx,      edx
                      or          eax,      ebx
                    ENDIF       
                    IFDEF          __NOPROCS
                      ENDM        
                    ELSE        
                      ret         
F                     ENDP      
                    ENDIF

FF                  MACRO       t, kt
                      mov       eax,        kt
                      mov       bx,         t               ;
                      call      __FF
                    ENDM

; One could add an option to have the __FF, __GG and __HH procedures be
; macros instead. The SHATransform procedure would increase in size by
; well-near eighty-fold, however.

__FF          PROC    NEAR  ; assumes: eax = kt, bx = index in w
              mov         temp,             eax
              mov         eax,              ds: [si][bx]
              add         temp,             eax
              mov         eax,              a
              rol         eax,              5
              add         temp,             eax
              mov         ebx,              B
              mov         ecx,              C
              mov         edx,              D
              IFDEF        __NOPROCS
                F           
              ELSE        
                call      F
              ENDIF       
              add       temp,               eax
              mov       eax,                E
              add       temp,               eax
              IFDEF     __MISCOPT
                mov     E,                edx
                mov     D,                ecx
              ELSE        
                mov     eax,                D
                mov     E,                  eax
                mov     eax,                C
                mov     D,                  eax
              ENDIF       
              mov       eax,                B
              rol       eax,                  30
              mov       C,                    eax
              mov       eax,                  A
              mov       B,                    eax
              mov       eax,                  temp
              mov       A,                    eax
              ret         
__FF          ENDP                  


; - Auxiliary function G(x,y,z)=xy v xz v yz -------------------------------

; if __FASTERMETHOD is defined, G(x,y,z)=xy v z(x v y)

                    IFDEF          __NOPROCS
G                     MACRO     
                    ELSE        
G                     PROC      NEAR
                    ENDIF
                    IFDEF       __FASTERMETHOD
                      mov         eax,      ebx
                      or          eax,      ecx
                      and         eax,      edx
                      and         ebx,      ecx
                      or          eax,      ebx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      and         ebx,      edx
                      and         ecx,      edx
                      or          eax,      ebx
                      or          eax,      ecx
                    ENDIF
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
G                     ENDP      
                    ENDIF       

GG                MACRO         t, kt
                    mov         eax,          kt
                    mov         bx,           t
                    call        __GG
                  ENDM

__GG              PROC          NEAR
                  mov           temp,         eax
                  mov           eax,          ds: [si][bx]
                  add           temp,         eax
                  mov           eax,          A
                  rol           eax,          5
                  add           temp,         eax
                  mov           ebx,          B
                  mov           ecx,          C
                  mov           edx,          D
                  IFDEF       __NOPROCS
                    G           
                  ELSE        
                    call        G
                  ENDIF       
                  add           temp,       eax
                  mov           eax,        E
                  add           temp,       eax
                  IFDEF       __MISCOPT
                    mov         E,          edx
                    mov         D,          ecx
                  ELSE        
                    mov         eax,        D
                    mov         E,          eax
                    mov         eax,        C
                    mov         D,          eax
                  ENDIF       
                  mov           eax,        B
                  rol           eax,        30
                  mov           C,          eax
                  mov           eax,        A
                  mov           B,          eax
                  mov           eax,        temp
                  mov           A,          eax
                  ret         
__GG              ENDP                      

; - Auxiliary function H(x,y,z)=x xor y xor z ------------------------------
                    
                    IFDEF          __NOPROCS
H                      MACRO     
                    ELSE        
H                      PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    xor         eax,        ecx
                    xor         eax,        edx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
H                   ENDP      
                    ENDIF       

HH              MACRO         t, kt
                  mov         eax,            kt
                  mov         bx,             t               ;
                  call        __HH
                ENDM

__HH            PROC          NEAR
                mov         temp,              eax
                mov         eax,               ds: [si][bx]
                add         temp,              eax
                mov         eax,               A
                rol         eax,               5
                add         temp,              eax
                mov         ebx,               B
                mov         ecx,               C
                mov         edx,               D
                IFDEF       __NOPROCS
                  H           
                ELSE        
                  call        H
                ENDIF       
                add         temp,              eax
                mov         eax,               E
                add         temp,              eax
                IFDEF       __MISCOPT
                  mov         E,               edx
                  mov         D,               ecx
                ELSE        
                  mov         eax,             D
                  mov         E,               eax
                  mov         eax,             C
                  mov         D,               eax
                  ENDIF       
                mov         eax,               B
                rol         eax,               30
                mov         C,                 eax
                mov         eax,               A
                mov         B,                 eax
                mov         eax,               temp
                mov         A,                 eax
                ret         
__HH            ENDP                          

; - Initializate Digest: ---------------------------------------------------
                 
                 IFNDEF __TRANSFORMONLY
; if __TRANSFORMONLY defined, no SHAInit routine will assembled.
                    PUBLIC      PASCAL SHAInit
SHAInit             PROC        PASCAL FAR digest: DWORD
                    IFDEF     __COPYINIT
                      push      ds
                      mov       ax,       cs
                      mov       ds,       ax
                      mov       si,       OFFSET initial_values
                    ENDIF       
                    les         di,       digest
                    IFNDEF    __COPYINIT
                      mov       A,      67452301h
                      mov       B,     0EFCDAB89h
                      mov       C,      98BADCFEh
                      mov       D,      10325476h
                      mov       E,     0C3D2E1F0h
                     IFDEF    __CONTEXT 
                      mov     ctxlobits, 0
                      mov     ctxhibits, 0  
                     ENDIF
                    ELSE 
                     IFDEF    __CONTEXT 
                      mov       cx,     7
                     ELSE
                      mov       cx,     5
                     ENDIF
                      cld         
                      rep         movsd
                      pop         ds
                    ENDIF       
                    ret        
                    
                    IFDEF       __COPYINIT or __CONTEXT
initial_values      LABEL     DWORD
  DD                  67452301h
  DD                 0EFCDAB89h
  DD                  98BADCFEh
  DD                  10325476h
  DD                 0C3D2E1F0h
IFDEF __CONTEXT
  DD  2 DUP (?)         
ENDIF
                    ENDIF
SHAInit             ENDP

; - Update Context Buffer: -------------------------------------------------
                 IFDEF  __CONTEXT
                    PUBLIC      PASCAL SHAUpdate
SHAUpdate           PROC        PASCAL FAR ctx: DWORD, buff: DWORD, len: WORD
                    push        ds
                    lds         si,     buff
                    les         di,     ctx
 @0:                cmp         len,    0
                    jz          SHORT   @3
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         cx,     40h
                    sub         cx,     ax
                    cmp         cx,     len
                    jna         SHORT @1
                    mov         cx,    len
 @1:                sub         len,   cx
                    mov         bx,    ax
                    mov         ax,    cx
                    and         eax,   0FFFFh
                    shl         eax,    3
                    add         ctxlobits, eax
                    adc         ctxhibits, 0  
                    mov         dx,     di
                    add         di,     28
                    add         di,     bx
                    add         bx,     cx
                    MCPY
                    mov         di,     dx
                    cmp         bx,     40h
                    jnz         SHORT @2
                    XFORM
 @2:                jmp         SHORT @0
 @3:                   
                    pop          ds
                    ret
SHAUpdate           ENDP

; - Wrap-up Context Buffer: ------------------------------------------------

                    PUBLIC      PASCAL SHAFinal
SHAFinal            PROC        PASCAL FAR digest: DWORD, ctx: DWORD
                    push        ds
                    les         di,     ctx
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         bx,     ax
                    mov         dx,     di
                    add         di,     28
                    add         di,     bx
                    mov         al,     80h
                    cld
                    stosb
                    inc         bx
                    mov         cx,     40h
                    sub         cx,     bx
                    cmp         bx,     38h
                    jb          SHORT @4
                    MSET
                    mov         di,     dx
                    XFORM
                    add         di,     28
                    mov         cx,     38h             
 @4:                MSET
                    mov         di,     dx
                    mov         eax,    ctxlobits
                    BSWAP386
                    mov         ctxlofin, eax
                    mov         eax,    ctxhibits
                    BSWAP386
                    mov         ctxhifin, eax
                    XFORM
                    mov         si,     di
                    mov         ax,     es
                    mov         ds,     ax
                    les         di,     digest
                    mov         cx,     5
savefinalhash:      lodsd
                    BSWAP386
                    stosd
                    loop        savefinalhash
                    mov         es,     ax        ; wipe buffer in case
                    mov         di,     dx        ; there is anything
                    mov         cx,     (20+8+64) ; sensitive
                    MSET
                    pop         ds
                    ret
SHAFinal            ENDP

                  ENDIF
                 ENDIF
; - SHA Transformation: ----------------------------------------------------

W_sub_t              EQU        <es: [di][bx]>

                    PUBLIC      PASCAL SHATransform
SHATransform        PROC        PASCAL FAR hashdata: DWORD,digest: DWORD
                  IFDEF         __LOCALVARS
                    LOCAL       W[80]: DWORD, temp: DWORD, AA: DWORD, BB: DWORD, CC: DWORD, DD0: DWORD, EE: DWORD
; Note: putting the locals on separate lines does not guarantee that they
;       will be in the proper order when assembled by TASM.
                  ENDIF       
                    push        ds
                    IFDEF          __NOSTOR
                      lds         si,       digest
                      IFDEF          __LOCALVARS
                        lea         di,     OFFSET AA
                        mov         ax,     ss
                      ELSE        
                        mov         di,     OFFSET AA
                        mov         ax,     cs
                      ENDIF       
                      mov         es,       ax
                      mov         cx,       5
                      cld         
                      rep         movsd
                    ENDIF       
                    lds         si,         hashdata      ; *data[64]
                    IFDEF       __LOCALVARS
                      lea       di,         W
                      mov       ax,         ss
                    ELSE
                      mov       di,         OFFSET W
                      mov       ax,         cs
                    ENDIF
                    mov         es,         ax
                    mov         cx,         16
                    IFNDEF       __NOSTOR
                      cld
                    ENDIF
                    mov         dx,         di             ;
swaploop:           lodsd
                    BSWAP386
                    stosd
                    loop        swaploop
                    mov         di,         dx
                    mov         cx,         (4*16)        ;
expansionloop:      
                    mov         bx,         cx            ;
                    sub         bx,         (4*3)         ;
                    mov         eax,        W_sub_t
                    sub         bx,         (4*5)         ;
                    xor         eax,        W_sub_t
                    sub         bx,         (4*6)         ;
                    xor         eax,        W_sub_t
                    sub         bx,         (4*2)         ;
                    xor         eax,        W_sub_t
                    mov         bx,         cx            ;
                    IFDEF       __REVISED
                      rol       eax,      1
                    ENDIF       
                    mov         W_sub_t,    eax
                    add         cx,         4
                    cmp         cx,         (4*80)
                    jb          SHORT expansionloop
                    mov         ax,         es            ;
                    mov         ds,         ax            ;
                    mov         si,         di
                    les         di,         digest        ; *hash[20]
                    IFNDEF       __NOSTOR
                      STOR        AA,       A             ;
                      STOR        BB,       B
                      STOR        CC,       C
                      STOR        DD0,      D
                      STOR        EE,       E
                    ENDIF
; -Round 1 -----------------------------------------------------------------
                    FF          0*4,        5a827999h
                    FF          1*4,        5a827999h
                    FF          2*4,        5a827999h
                    FF          3*4,        5a827999h
                    FF          4*4,        5a827999h
                    FF          5*4,        5a827999h
                    FF          6*4,        5a827999h
                    FF          7*4,        5a827999h
                    FF          8*4,        5a827999h
                    FF          9*4,        5a827999h
                    FF          10*4,       5a827999h
                    FF          11*4,       5a827999h
                    FF          12*4,       5a827999h
                    FF          13*4,       5a827999h
                    FF          14*4,       5a827999h
                    FF          15*4,       5a827999h
                    FF          16*4,       5a827999h
                    FF          17*4,       5a827999h
                    FF          18*4,       5a827999h
                    FF          19*4,       5a827999h
; -Round 2 -----------------------------------------------------------------
                    HH          20*4,       6ed9eba1h
                    HH          21*4,       6ed9eba1h
                    HH          22*4,       6ed9eba1h
                    HH          23*4,       6ed9eba1h
                    HH          24*4,       6ed9eba1h
                    HH          25*4,       6ed9eba1h
                    HH          26*4,       6ed9eba1h
                    HH          27*4,       6ed9eba1h
                    HH          28*4,       6ed9eba1h
                    HH          29*4,       6ed9eba1h
                    HH          30*4,       6ed9eba1h
                    HH          31*4,       6ed9eba1h
                    HH          32*4,       6ed9eba1h
                    HH          33*4,       6ed9eba1h
                    HH          34*4,       6ed9eba1h
                    HH          35*4,       6ed9eba1h
                    HH          36*4,       6ed9eba1h
                    HH          37*4,       6ed9eba1h
                    HH          38*4,       6ed9eba1h
                    HH          39*4,       6ed9eba1h
; -Round 3 -----------------------------------------------------------------
                    GG          40*4,       8f1bbcdch
                    GG          41*4,       8f1bbcdch
                    GG          42*4,       8f1bbcdch
                    GG          43*4,       8f1bbcdch
                    GG          44*4,       8f1bbcdch
                    GG          45*4,       8f1bbcdch
                    GG          46*4,       8f1bbcdch
                    GG          47*4,       8f1bbcdch
                    GG          48*4,       8f1bbcdch
                    GG          49*4,       8f1bbcdch
                    GG          50*4,       8f1bbcdch
                    GG          51*4,       8f1bbcdch
                    GG          52*4,       8f1bbcdch
                    GG          53*4,       8f1bbcdch
                    GG          54*4,       8f1bbcdch
                    GG          55*4,       8f1bbcdch
                    GG          56*4,       8f1bbcdch
                    GG          57*4,       8f1bbcdch
                    GG          58*4,       8f1bbcdch
                    GG          59*4,       8f1bbcdch
; -Round 4 -----------------------------------------------------------------
                    HH          60*4,       0ca62c1d6h
                    HH          61*4,       0ca62c1d6h
                    HH          62*4,       0ca62c1d6h
                    HH          63*4,       0ca62c1d6h
                    HH          64*4,       0ca62c1d6h
                    HH          65*4,       0ca62c1d6h
                    HH          66*4,       0ca62c1d6h
                    HH          67*4,       0ca62c1d6h
                    HH          68*4,       0ca62c1d6h
                    HH          69*4,       0ca62c1d6h
                    HH          70*4,       0ca62c1d6h
                    HH          71*4,       0ca62c1d6h
                    HH          72*4,       0ca62c1d6h
                    HH          73*4,       0ca62c1d6h
                    HH          74*4,       0ca62c1d6h
                    HH          75*4,       0ca62c1d6h
                    HH          76*4,       0ca62c1d6h
                    HH          77*4,       0ca62c1d6h
                    HH          78*4,       0ca62c1d6h
                    HH          79*4,       0ca62c1d6h

; --------------------------------------------------------------------------
                    ADDD        A, AA   ;
                    ADDD        B, BB
                    ADDD        C, CC
                    ADDD        D, DD0
                    ADDD        E, EE
                    pop         ds               ;
                    ret
SHAtransform        ENDP
                  END
