; =========================================================================
; MemCopy.Asm (c) Copyright 1994 Robert Rothenburg Walking-Owl (27 Nov 94)
; =========================================================================
; 32-bit memory copy routine for Turbo Pascal as a fast replacement for                    
; the Move() procedure. (Derived from the FastMem.Pas 3.2b unit.)

                    .386        

threshold           equ         8

code                segment     byte public use16
                    assume      cs: code
                    
; =========================================================================
; procedure MemCopy(var source,dest; size: word);
; =========================================================================
                    public      memcopy                     ;
memcopy             proc        far
                    push        bp
                    mov         bp,         sp
                    mov         bx,         ds
                    lds         si,         [bp+0ch]        ;
                    les         di,         [bp+08h]        ;
                    mov         cx,         [bp+06h]        ;
                    add         si,         cx              ;
                    cmp         si,         di
                    jnb         short backwards_mc          ;
forward_mc:         
                    sub         si,         cx              ;
                    call        _move
exit_mc:            
                    mov         ds,         bx
                    pop         bp                          ;
                    ret         10
backwards_mc:                                               ;           
                    add         di,         cx              ;
                    call        _moveb
                    mov         ds,         bx
                    pop         bp                          ;
                    ret         10
memcopy             endp        

; =========================================================================
; Forward Move routine
; =========================================================================
                    public      _move
_move               proc        near
                    cld                                     ;
                    cmp         cx,         threshold       ;
                    jnb         short move32                ;
move16:                                                     ;           
                    shr         cx,         1               ;
                    jnc         short word0                 ;
                    movsb                                   ;
word0:              rep         movsw                       ;
                    ret                                     ;
move32:                                                     ;           
                    test        di,         11b             ;
                    jz          short aligned_move          ;
;                   push        dx                          ; save dx
                    mov         dx,         cx              ;
                    mov         cx,         di              ;
                    and         cx,         11b             ;
                    neg         cx                          ;
                    add         cx,         4               ;
                    sub         dx,         cx              ;
                    rep         movsb                       ;
                    mov         cx,         dx              ;
;                   pop         dx                          ; restore dx
aligned_move:                                               ;           
                    shr         cx,         1               ;
                    jnc         short word1                 ;
                    movsb                                   ;
word1:              shr         cx, 1                       ;
                    rep         movsd                       ;
                    adc         cx,         0               ;
                    rep         movsw                       ;
                    ret                                     ;
_move               endp        

; =========================================================================
; Backwards Move routine (in case of overlapping ds:si+cx with es:di)
; =========================================================================
                    public      _moveb
_moveb              proc        near
                    dec         si                          ;
                    dec         di
                    std                                     ;
                    cmp         cx,         threshold       ;
                    jnb         short mdwordb
mvwordb:                                                    ;           
                    dec         si                          ;
                    dec         di
                    shr         cx,         1
                    rep         movsw                       ;
                    adc         cl,         0
                    inc         si                          ;
                    inc         di
                    rep         movsb                       ;
                    ret         
mdwordb:            
                    test        di,         11b             ;
                    jz          short alignedback
                    mov         dx,         cx
                    mov         cx,         di
                    and         cx,         11b
                    sub         dx,         cx
                    rep         movsb
                    mov         cx,         dx
alignedback:        
                    shr         cx,         1               ;
                    jnc         short wordb                 ;
                    movsb                                   ;
wordb:              
                    sub         si,         3               ;
                    sub         di,         3
                    shr         cx,         1
                    rep         movsd                       ;
                    adc         cl,         0
                    add         si,         2               ;
                    add         di,         2
                    rep         movsw                       ;
                    ret         
_moveb              endp        
code                ends        
                  end         
