#include <stdio.h>
/*-------------------------*/
/* move forward to given ctb */
int skip2ctb(FILE * inf, unsigned char ctb, unsigned char ctbmask)
{
  unsigned char t, dbuf[8];
  int ch, i = 0, j;

  while (!feof(inf)) {          /* skip to literal header */
    t = fgetc(inf);
    ch = 1 << (t & 3);          /* length of length */
    ch = fread(dbuf, 1, ch, inf);
    if (ch <= 0)
      return ch;
    for (j = 0, i = 0; j < ch; j++)
      i = (i << 8) + dbuf[j];
    if ((t & ctbmask) == ctb)
      break;
    fseek(inf, i, SEEK_CUR);
  }
  return i;
}
